/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CjkBigramIgnoredScript;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CjkBigramTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<CjkBigramIgnoredScript> ignoredScripts;
    @Nullable
    private final Boolean outputUnigrams;
    public static final JsonpDeserializer<CjkBigramTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CjkBigramTokenFilter::setupCjkBigramTokenFilterDeserializer);

    private CjkBigramTokenFilter(Builder builder) {
        super(builder);
        this.ignoredScripts = ApiTypeHelper.unmodifiable(builder.ignoredScripts);
        this.outputUnigrams = builder.outputUnigrams;
    }

    public static CjkBigramTokenFilter of(Function<Builder, ObjectBuilder<CjkBigramTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.CjkBigram;
    }

    public final List<CjkBigramIgnoredScript> ignoredScripts() {
        return this.ignoredScripts;
    }

    @Nullable
    public final Boolean outputUnigrams() {
        return this.outputUnigrams;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "cjk_bigram");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.ignoredScripts)) {
            generator.writeKey("ignored_scripts");
            generator.writeStartArray();
            for (CjkBigramIgnoredScript item0 : this.ignoredScripts) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.outputUnigrams != null) {
            generator.writeKey("output_unigrams");
            generator.write(this.outputUnigrams);
        }
    }

    protected static void setupCjkBigramTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::ignoredScripts, JsonpDeserializer.arrayDeserializer(CjkBigramIgnoredScript._DESERIALIZER), "ignored_scripts");
        op.add(Builder::outputUnigrams, JsonpDeserializer.booleanDeserializer(), "output_unigrams");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CjkBigramTokenFilter> {
        @Nullable
        private List<CjkBigramIgnoredScript> ignoredScripts;
        @Nullable
        private Boolean outputUnigrams;

        public final Builder ignoredScripts(List<CjkBigramIgnoredScript> list) {
            this.ignoredScripts = Builder._listAddAll(this.ignoredScripts, list);
            return this;
        }

        public final Builder ignoredScripts(CjkBigramIgnoredScript value, CjkBigramIgnoredScript ... values) {
            this.ignoredScripts = Builder._listAdd(this.ignoredScripts, value, values);
            return this;
        }

        public final Builder outputUnigrams(@Nullable Boolean value) {
            this.outputUnigrams = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CjkBigramTokenFilter build() {
            this._checkSingleUse();
            return new CjkBigramTokenFilter(this);
        }
    }
}

