/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestConvert {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestConvert::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("mutate", IngestConvert.convertHash(processor)));
    }

    static String convertHash(Map<String, Map> processor) {
        Map convert_json = processor.get("convert");
        String mutate_contents = IngestConverter.createField(IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)convert_json.get("field"))), IngestConverter.quoteString((String)convert_json.get("type")));
        return IngestConverter.createField("convert", IngestConverter.wrapInCurly(mutate_contents));
    }

    public static boolean has_convert(Map<String, Object> processor) {
        return processor.containsKey("convert");
    }
}

