/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyMethods {
    private JavaProxyMethods() {
    }

    public static RubyModule createJavaProxyMethods(ThreadContext context) {
        RubyModule JavaProxyMethods2 = context.runtime.defineModule("JavaProxyMethods");
        JavaProxyMethods2.defineAnnotatedMethods(JavaProxyMethods.class);
        return JavaProxyMethods2;
    }

    @JRubyMethod
    public static IRubyObject java_class(ThreadContext context, IRubyObject recv2) {
        return JavaProxy.getJavaClass(recv2.getMetaClass().getRealClass());
    }

    @JRubyMethod(name={"java_object", "to_java_object"})
    public static IRubyObject java_object(ThreadContext context, IRubyObject recv2) {
        Object javaObj = recv2.dataGetStruct();
        if (javaObj instanceof IRubyObject) {
            return (IRubyObject)javaObj;
        }
        return Java.getInstance(context.runtime, javaObj);
    }

    @JRubyMethod(name={"eql?"})
    public static IRubyObject op_eql(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return JavaProxyMethods.op_equal(context, recv2, obj);
    }

    @JRubyMethod(name={"=="})
    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (recv2 instanceof JavaProxy) {
            return JavaProxyMethods.equals(context.runtime, ((JavaProxy)recv2).getObject(), other);
        }
        if (recv2.dataGetStruct() instanceof RubyBasicObject) {
            return ((RubyBasicObject)recv2.dataGetStruct()).op_equal(context, other);
        }
        return context.nil;
    }

    static RubyBoolean equals(Ruby runtime2, Object thisValue, IRubyObject other) {
        IRubyObject otherValue = JavaUtil.unwrapJava(other, RubyBasicObject.NEVER);
        if (otherValue == RubyBasicObject.NEVER) {
            return runtime2.getFalse();
        }
        if (thisValue == null) {
            return runtime2.newBoolean(otherValue == null);
        }
        return runtime2.newBoolean(thisValue.equals(otherValue));
    }

    @JRubyMethod
    public static IRubyObject to_s(ThreadContext context, IRubyObject recv2) {
        if (recv2 instanceof JavaProxy) {
            return JavaProxyMethods.to_s(context.runtime, ((JavaProxy)recv2).getObject());
        }
        if (recv2.dataGetStruct() instanceof IRubyObject) {
            return ((RubyBasicObject)recv2.dataGetStruct()).to_s();
        }
        return ((RubyBasicObject)recv2).to_s();
    }

    static IRubyObject to_s(Ruby runtime2, Object javaObject) {
        if (javaObject != null) {
            String stringValue = javaObject.toString();
            if (stringValue == null) {
                return runtime2.getNil();
            }
            return RubyString.newUnicodeString(runtime2, stringValue);
        }
        return RubyString.newEmptyString(runtime2);
    }

    @JRubyMethod
    public static IRubyObject inspect(IRubyObject recv2) {
        if (recv2 instanceof RubyBasicObject) {
            return ((RubyBasicObject)recv2).hashyInspect();
        }
        return recv2.inspect();
    }

    @JRubyMethod
    public static IRubyObject hash(ThreadContext context, IRubyObject recv2) {
        if (recv2 instanceof JavaProxy) {
            return RubyFixnum.newFixnum(context.runtime, ((JavaProxy)recv2).getObject().hashCode());
        }
        if (recv2.dataGetStruct() instanceof IRubyObject) {
            return ((RubyBasicObject)recv2.dataGetStruct()).hash();
        }
        return ((RubyBasicObject)recv2).hash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public static IRubyObject rbSynchronized(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject value2;
        Object lock2;
        if (recv2 instanceof JavaProxy) {
            lock2 = ((JavaProxy)recv2).getObject();
            value2 = recv2;
        } else if (recv2.dataGetStruct() instanceof IRubyObject) {
            value2 = (IRubyObject)recv2.dataGetStruct();
            lock2 = value2;
        } else {
            value2 = recv2;
            lock2 = value2;
        }
        Object object = lock2;
        synchronized (object) {
            return block.yield(context, value2);
        }
    }
}

