/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SphericalMercatorUtils;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafShapeFieldData;

public abstract class AbstractAtomicGeoShapeShapeFieldData
extends LeafShapeFieldData<GeoShapeValues> {
    public AbstractAtomicGeoShapeShapeFieldData(ToScriptFieldFactory<GeoShapeValues> toScriptFieldFactory) {
        super(toScriptFieldFactory);
    }

    public static LeafShapeFieldData<GeoShapeValues> empty(int maxDoc, ToScriptFieldFactory<GeoShapeValues> toScriptFieldFactory) {
        return new LeafShapeFieldData.Empty<GeoShapeValues>(toScriptFieldFactory, GeoShapeValues.EMPTY);
    }

    public static final class GeoShapeScriptValues
    extends LeafShapeFieldData.ShapeScriptValues<GeoPoint, GeoShapeValues.GeoShapeValue>
    implements ScriptDocValues.Geometry {
        public GeoShapeScriptValues(ScriptDocValues.GeometrySupplier<GeoPoint, GeoShapeValues.GeoShapeValue> supplier) {
            super(supplier);
        }

        @Override
        public GeoShapeValues.GeoShapeValue get(int index) {
            return (GeoShapeValues.GeoShapeValue)super.get(index);
        }

        @Override
        public GeoShapeValues.GeoShapeValue getValue() {
            return (GeoShapeValues.GeoShapeValue)super.getValue();
        }

        @Override
        public GeoBoundingBox getBoundingBox() {
            return (GeoBoundingBox)super.getBoundingBox();
        }

        @Override
        public double getMercatorWidth() {
            return SphericalMercatorUtils.lonToSphericalMercator(this.getBoundingBox().right()) - SphericalMercatorUtils.lonToSphericalMercator(this.getBoundingBox().left());
        }

        @Override
        public double getMercatorHeight() {
            return SphericalMercatorUtils.latToSphericalMercator(this.getBoundingBox().top()) - SphericalMercatorUtils.latToSphericalMercator(this.getBoundingBox().bottom());
        }
    }
}

