/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.slice;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.slice.SliceQuery;

public final class DocIdSliceQuery
extends SliceQuery {
    public DocIdSliceQuery(int id, int max) {
        super("_doc", id, max);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        int sliceSize;
        int sliceStart;
        int maxDoc = searcher.getTopReaderContext().reader().maxDoc();
        int remainder = maxDoc % this.getMax();
        int quotient = maxDoc / this.getMax();
        if (this.getId() < remainder) {
            sliceStart = (quotient + 1) * this.getId();
            sliceSize = quotient + 1;
        } else {
            sliceStart = remainder * (quotient + 1) + (this.getId() - remainder) * quotient;
            sliceSize = quotient;
        }
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) {
                DocIdSetIterator iterator = 1.createIterator(context, sliceStart, sliceStart + sliceSize);
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            private static DocIdSetIterator createIterator(LeafReaderContext context, int sliceStart2, int sliceEnd) {
                int leafStart = context.docBase;
                int leafEnd = context.docBase + context.reader().maxDoc();
                if (leafEnd <= sliceStart2 || leafStart >= sliceEnd) {
                    return DocIdSetIterator.empty();
                }
                int start = Math.max(leafStart, sliceStart2) - context.docBase;
                int end = Math.min(leafEnd, sliceEnd) - context.docBase;
                return DocIdSetIterator.range(start, end);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }
}

