/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Event;
import co.elastic.logstash.filters.elasticintegration.IntegrationRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.core.Releasable;

public class IntegrationBatch {
    final ArrayList<Event> events;

    public IntegrationBatch(Collection<Event> events) {
        this.events = new ArrayList<Event>(events);
    }

    void eachRequest(Supplier<Releasable> releasableSupplier, Consumer<IntegrationRequest> consumer) {
        for (int i = 0; i < this.events.size(); ++i) {
            consumer.accept(new Request(i, releasableSupplier.get()));
        }
    }

    private class Request
    implements IntegrationRequest {
        private final int idx;
        private final Releasable handle;

        public Request(int idx, Releasable releasable) {
            this.idx = idx;
            this.handle = releasable;
        }

        @Override
        public Event event() {
            return IntegrationBatch.this.events.get(this.idx);
        }

        @Override
        public void complete(UnaryOperator<Event> eventSwapper) {
            Event sourceEvent = this.event();
            Event resultEvent = (Event)eventSwapper.apply(sourceEvent);
            if (resultEvent != sourceEvent) {
                IntegrationBatch.this.events.set(this.idx, resultEvent);
            }
            this.handle.close();
        }
    }
}

