/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.datasource;

import java.net.InetAddress;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.datageneration.FieldType;
import org.elasticsearch.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.test.ESTestCase;

public class DefaultMappingParametersHandler
implements DataSourceHandler {
    private static final String FORMAT = "yyyy_MM_dd_HH_mm_ss_n";

    @Override
    public DataSourceResponse.LeafMappingParametersGenerator handle(DataSourceRequest.LeafMappingParametersGenerator request) {
        FieldType fieldType = FieldType.tryParse(request.fieldType());
        if (fieldType == null) {
            return null;
        }
        return new DataSourceResponse.LeafMappingParametersGenerator(switch (fieldType) {
            default -> throw new IncompatibleClassChangeError();
            case FieldType.KEYWORD -> this.keywordMapping(request);
            case FieldType.LONG, FieldType.INTEGER, FieldType.SHORT, FieldType.BYTE, FieldType.DOUBLE, FieldType.FLOAT, FieldType.HALF_FLOAT, FieldType.UNSIGNED_LONG -> this.numberMapping(fieldType);
            case FieldType.SCALED_FLOAT -> this.scaledFloatMapping();
            case FieldType.COUNTED_KEYWORD -> this.countedKeywordMapping();
            case FieldType.BOOLEAN -> this.booleanMapping();
            case FieldType.DATE -> this.dateMapping();
            case FieldType.GEO_POINT -> this.geoPointMapping();
            case FieldType.TEXT -> this.textMapping(request);
            case FieldType.IP -> this.ipMapping();
            case FieldType.CONSTANT_KEYWORD -> this.constantKeywordMapping();
            case FieldType.WILDCARD -> this.wildcardMapping();
        });
    }

    private Supplier<Map<String, Object>> numberMapping(FieldType fieldType) {
        return () -> {
            HashMap<String, Object> mapping = DefaultMappingParametersHandler.commonMappingParameters();
            if (ESTestCase.randomBoolean()) {
                mapping.put("ignore_malformed", ESTestCase.randomBoolean());
            }
            if (ESTestCase.randomDouble() <= 0.2) {
                Number value = switch (fieldType) {
                    case FieldType.LONG -> ESTestCase.randomLong();
                    case FieldType.UNSIGNED_LONG -> ESTestCase.randomNonNegativeLong();
                    case FieldType.INTEGER -> ESTestCase.randomInt();
                    case FieldType.SHORT -> ESTestCase.randomShort();
                    case FieldType.BYTE -> ESTestCase.randomByte();
                    case FieldType.DOUBLE -> ESTestCase.randomDouble();
                    case FieldType.FLOAT, FieldType.HALF_FLOAT -> Float.valueOf(ESTestCase.randomFloat());
                    default -> throw new IllegalStateException("Unexpected field type");
                };
                mapping.put("null_value", value);
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> keywordMapping(DataSourceRequest.LeafMappingParametersGenerator request) {
        return () -> {
            Set options;
            HashMap<String, Object> mapping = DefaultMappingParametersHandler.commonMappingParameters();
            if (ESTestCase.randomDouble() <= 0.05 && !(options = request.eligibleCopyToFields().stream().filter(f -> !f.equals(request.fieldName())).collect(Collectors.toSet())).isEmpty()) {
                mapping.put("copy_to", ESTestCase.randomFrom(options));
            }
            if (ESTestCase.randomDouble() <= 0.2) {
                mapping.put("ignore_above", ESTestCase.randomIntBetween(1, 100));
            }
            if (ESTestCase.randomDouble() <= 0.2) {
                mapping.put("null_value", ESTestCase.randomAlphaOfLengthBetween(0, 10));
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> scaledFloatMapping() {
        return () -> {
            HashMap<String, Object> mapping = DefaultMappingParametersHandler.commonMappingParameters();
            mapping.put("scaling_factor", ESTestCase.randomFrom(10, 1000, 100000, 100.5));
            if (ESTestCase.randomDouble() <= 0.2) {
                mapping.put("null_value", ESTestCase.randomDouble());
            }
            if (ESTestCase.randomBoolean()) {
                mapping.put("ignore_malformed", ESTestCase.randomBoolean());
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> countedKeywordMapping() {
        return () -> Map.of("index", ESTestCase.randomBoolean());
    }

    private Supplier<Map<String, Object>> booleanMapping() {
        return () -> {
            HashMap<String, Object> mapping = DefaultMappingParametersHandler.commonMappingParameters();
            if (ESTestCase.randomDouble() <= 0.2) {
                mapping.put("null_value", ESTestCase.randomFrom(true, Boolean.valueOf(false), "true", "false"));
            }
            if (ESTestCase.randomBoolean()) {
                mapping.put("ignore_malformed", ESTestCase.randomBoolean());
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> dateMapping() {
        return () -> {
            HashMap<String, Object> mapping = DefaultMappingParametersHandler.commonMappingParameters();
            String format = null;
            if (ESTestCase.randomBoolean()) {
                format = FORMAT;
                mapping.put("format", format);
            }
            if (ESTestCase.randomDouble() <= 0.2) {
                Instant instant = ESTestCase.randomInstantBetween(Instant.parse("2300-01-01T00:00:00Z"), Instant.parse("2350-01-01T00:00:00Z"));
                if (format == null) {
                    mapping.put("null_value", instant.toEpochMilli());
                } else {
                    mapping.put("null_value", DateTimeFormatter.ofPattern(format, Locale.ROOT).withZone(ZoneId.from(ZoneOffset.UTC)).format(instant));
                }
            }
            if (ESTestCase.randomBoolean()) {
                mapping.put("ignore_malformed", ESTestCase.randomBoolean());
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> geoPointMapping() {
        return () -> {
            HashMap<String, Object> mapping = DefaultMappingParametersHandler.commonMappingParameters();
            if (ESTestCase.randomDouble() <= 0.2) {
                Point point = GeometryTestUtils.randomPoint(false);
                mapping.put("null_value", WellKnownText.toWKT((Geometry)point));
            }
            if (ESTestCase.randomBoolean()) {
                mapping.put("ignore_malformed", ESTestCase.randomBoolean());
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> textMapping(DataSourceRequest.LeafMappingParametersGenerator request) {
        return () -> {
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            mapping.put("store", ESTestCase.randomBoolean());
            mapping.put("index", ESTestCase.randomBoolean());
            if (ESTestCase.randomDouble() <= 0.1) {
                Map<String, Object> keywordMultiFieldMapping = this.keywordMapping(request).get();
                keywordMultiFieldMapping.put("type", "keyword");
                keywordMultiFieldMapping.remove("copy_to");
                mapping.put("fields", Map.of("kwd", keywordMultiFieldMapping));
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> ipMapping() {
        return () -> {
            HashMap<String, Object> mapping = DefaultMappingParametersHandler.commonMappingParameters();
            if (ESTestCase.randomDouble() <= 0.2) {
                mapping.put("null_value", NetworkAddress.format((InetAddress)ESTestCase.randomIp(ESTestCase.randomBoolean())));
            }
            if (ESTestCase.randomBoolean()) {
                mapping.put("ignore_malformed", ESTestCase.randomBoolean());
            }
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> constantKeywordMapping() {
        return () -> {
            HashMap<String, String> mapping = new HashMap<String, String>();
            mapping.put("value", ESTestCase.randomAlphaOfLengthBetween(0, 10));
            return mapping;
        };
    }

    private Supplier<Map<String, Object>> wildcardMapping() {
        return () -> {
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            if (ESTestCase.randomDouble() <= 0.2) {
                mapping.put("ignore_above", ESTestCase.randomIntBetween(1, 100));
            }
            if (ESTestCase.randomDouble() <= 0.2) {
                mapping.put("null_value", ESTestCase.randomAlphaOfLengthBetween(0, 10));
            }
            return mapping;
        };
    }

    public static HashMap<String, Object> commonMappingParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("store", ESTestCase.randomBoolean());
        map.put("index", ESTestCase.randomBoolean());
        map.put("doc_values", ESTestCase.randomBoolean());
        if (ESTestCase.randomBoolean()) {
            map.put("synthetic_source_keep", ESTestCase.randomFrom("none", "arrays", "all"));
        }
        return map;
    }

    @Override
    public DataSourceResponse.ObjectMappingParametersGenerator handle(DataSourceRequest.ObjectMappingParametersGenerator request) {
        if (request.isNested()) {
            assert (request.parentSubobjects() != ObjectMapper.Subobjects.DISABLED);
            return new DataSourceResponse.ObjectMappingParametersGenerator(() -> {
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (ESTestCase.randomBoolean()) {
                    parameters.put("dynamic", ESTestCase.randomFrom("true", "false", "strict"));
                }
                if (ESTestCase.randomBoolean()) {
                    parameters.put("synthetic_source_keep", "all");
                }
                return parameters;
            });
        }
        return new DataSourceResponse.ObjectMappingParametersGenerator(() -> {
            HashMap<String, String> parameters = new HashMap<String, String>();
            ObjectMapper.Subobjects subobjects = ESTestCase.randomValueOtherThan(ObjectMapper.Subobjects.AUTO, () -> ESTestCase.randomFrom(ObjectMapper.Subobjects.values()));
            if (request.parentSubobjects() == ObjectMapper.Subobjects.DISABLED || subobjects == ObjectMapper.Subobjects.DISABLED) {
                if (ESTestCase.randomBoolean()) {
                    parameters.put("enabled", "true");
                }
                return parameters;
            }
            if (ESTestCase.randomBoolean()) {
                parameters.put("subobjects", subobjects.toString());
            }
            if (ESTestCase.randomBoolean()) {
                parameters.put("dynamic", ESTestCase.randomFrom("true", "false", "strict", "runtime"));
            }
            if (ESTestCase.randomBoolean()) {
                parameters.put("enabled", ESTestCase.randomFrom("true", "false"));
            }
            if (ESTestCase.randomBoolean()) {
                String value = request.isRoot() ? ESTestCase.randomFrom("none", "arrays") : ESTestCase.randomFrom("none", "arrays", "all");
                parameters.put("synthetic_source_keep", value);
            }
            return parameters;
        });
    }
}

