/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.AggregatorsReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.sampler.Sampler;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplerAggregationBuilder;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalRandomSampler
extends InternalSingleBucketAggregation
implements Sampler {
    public static final String NAME = "mapped_random_sampler";
    public static final String PARSER_NAME = "random_sampler";
    private final int seed;
    private final Integer shardSeed;
    private final double probability;

    InternalRandomSampler(String name, long docCount, int seed, Integer shardSeed, double probability, InternalAggregations subAggregations, Map<String, Object> metadata) {
        super(name, docCount, subAggregations, metadata);
        this.seed = seed;
        this.shardSeed = shardSeed;
        this.probability = probability;
    }

    public InternalRandomSampler(StreamInput in) throws IOException {
        super(in);
        this.seed = in.readInt();
        this.probability = in.readDouble();
        this.shardSeed = in.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0) ? in.readOptionalInt() : null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeInt(this.seed);
        out.writeDouble(this.probability);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0)) {
            out.writeOptionalInt(this.shardSeed);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getType() {
        return PARSER_NAME;
    }

    @Override
    protected InternalSingleBucketAggregation newAggregation(String name, long docCount, InternalAggregations subAggregations) {
        return new InternalRandomSampler(name, docCount, this.seed, this.shardSeed, this.probability, subAggregations, this.metadata);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            long docCount = 0L;
            final AggregatorsReducer subAggregatorReducer = new AggregatorsReducer(InternalRandomSampler.this.getAggregations(), reduceContext, size);

            @Override
            public void accept(InternalAggregation aggregation) {
                this.docCount += ((InternalSingleBucketAggregation)aggregation).getDocCount();
                this.subAggregatorReducer.accept(((InternalSingleBucketAggregation)aggregation).getAggregations());
            }

            @Override
            public InternalAggregation get() {
                InternalAggregations aggs = this.subAggregatorReducer.get();
                if (reduceContext.isFinalReduce() && aggs != null) {
                    SamplingContext context = InternalRandomSampler.this.buildContext();
                    List<InternalAggregation> aaggregationList = aggs.asList();
                    ArrayList<InternalAggregation> sampledAggregations = new ArrayList<InternalAggregation>(aaggregationList.size());
                    for (InternalAggregation agg : aaggregationList) {
                        sampledAggregations.add(agg.finalizeSampling(context));
                    }
                    aggs = InternalAggregations.from(sampledAggregations);
                }
                return InternalRandomSampler.this.newAggregation(InternalRandomSampler.this.getName(), this.docCount, aggs);
            }

            @Override
            public void close() {
                Releasables.close((Releasable)this.subAggregatorReducer);
            }
        };
    }

    public SamplingContext buildContext() {
        return new SamplingContext(this.probability, this.seed, this.shardSeed);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RandomSamplerAggregationBuilder.SEED.getPreferredName(), this.seed);
        if (this.shardSeed != null) {
            builder.field(RandomSamplerAggregationBuilder.SHARD_SEED.getPreferredName(), this.shardSeed);
        }
        builder.field(RandomSamplerAggregationBuilder.PROBABILITY.getPreferredName(), this.probability);
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
        this.getAggregations().toXContentInternal(builder, params);
        return builder;
    }
}

