/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.elasticsearch.common.time.DateTimeParser;
import org.elasticsearch.common.time.ParseResult;

class JavaTimeDateTimeParser
implements DateTimeParser {
    private final DateTimeFormatter formatter;

    static UnaryOperator<JavaTimeDateTimeParser> createRoundUpParserGenerator(Consumer<DateTimeFormatterBuilder> modifyBuilder) {
        return p -> {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
            builder.append(p.formatter);
            modifyBuilder.accept(builder);
            return new JavaTimeDateTimeParser(builder.toFormatter(p.getLocale()));
        };
    }

    JavaTimeDateTimeParser(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    DateTimeFormatter formatter() {
        return this.formatter;
    }

    @Override
    public ZoneId getZone() {
        return this.formatter.getZone();
    }

    @Override
    public Locale getLocale() {
        return this.formatter.getLocale();
    }

    @Override
    public DateTimeParser withZone(ZoneId zone) {
        return new JavaTimeDateTimeParser(this.formatter.withZone(zone));
    }

    @Override
    public DateTimeParser withLocale(Locale locale) {
        return new JavaTimeDateTimeParser(this.formatter.withLocale(locale));
    }

    @Override
    public TemporalAccessor parse(CharSequence str) {
        return this.formatter.parse(str);
    }

    @Override
    public ParseResult tryParse(CharSequence str) {
        ParsePosition pos = new ParsePosition(0);
        TemporalAccessor result = (TemporalAccessor)this.formatter.toFormat().parseObject(str.toString(), pos);
        return pos.getIndex() == str.length() ? new ParseResult(result) : ParseResult.error(Math.max(pos.getErrorIndex(), pos.getIndex()));
    }
}

