/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.nodes.NodesOperationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;

public class NodesStatsRequestBuilder
extends NodesOperationRequestBuilder<NodesStatsRequest, NodesStatsResponse, NodesStatsRequestBuilder> {
    public NodesStatsRequestBuilder(ElasticsearchClient client, String[] nodeIds) {
        super(client, TransportNodesStatsAction.TYPE, new NodesStatsRequest(nodeIds));
    }

    public NodesStatsRequestBuilder all() {
        ((NodesStatsRequest)this.request).all();
        return this;
    }

    public NodesStatsRequestBuilder clear() {
        ((NodesStatsRequest)this.request).clear();
        return this;
    }

    public NodesStatsRequestBuilder setIndices(boolean indices) {
        ((NodesStatsRequest)this.request).indices(indices);
        return this;
    }

    public NodesStatsRequestBuilder setBreaker(boolean breaker) {
        this.addOrRemoveMetric(breaker, NodesStatsRequestParameters.Metric.BREAKER);
        return this;
    }

    public NodesStatsRequestBuilder setScript(boolean script) {
        this.addOrRemoveMetric(script, NodesStatsRequestParameters.Metric.SCRIPT);
        return this;
    }

    public NodesStatsRequestBuilder setIndices(CommonStatsFlags indices) {
        ((NodesStatsRequest)this.request).indices(indices);
        return this;
    }

    public NodesStatsRequestBuilder setOs(boolean os) {
        this.addOrRemoveMetric(os, NodesStatsRequestParameters.Metric.OS);
        return this;
    }

    public NodesStatsRequestBuilder setProcess(boolean process) {
        this.addOrRemoveMetric(process, NodesStatsRequestParameters.Metric.PROCESS);
        return this;
    }

    public NodesStatsRequestBuilder setJvm(boolean jvm) {
        this.addOrRemoveMetric(jvm, NodesStatsRequestParameters.Metric.JVM);
        return this;
    }

    public NodesStatsRequestBuilder setThreadPool(boolean threadPool) {
        this.addOrRemoveMetric(threadPool, NodesStatsRequestParameters.Metric.THREAD_POOL);
        return this;
    }

    public NodesStatsRequestBuilder setFs(boolean fs) {
        this.addOrRemoveMetric(fs, NodesStatsRequestParameters.Metric.FS);
        return this;
    }

    public NodesStatsRequestBuilder setTransport(boolean transport) {
        this.addOrRemoveMetric(transport, NodesStatsRequestParameters.Metric.TRANSPORT);
        return this;
    }

    public NodesStatsRequestBuilder setHttp(boolean http) {
        this.addOrRemoveMetric(http, NodesStatsRequestParameters.Metric.HTTP);
        return this;
    }

    public NodesStatsRequestBuilder setDiscovery(boolean discovery) {
        this.addOrRemoveMetric(discovery, NodesStatsRequestParameters.Metric.DISCOVERY);
        return this;
    }

    public NodesStatsRequestBuilder setIngest(boolean ingest) {
        this.addOrRemoveMetric(ingest, NodesStatsRequestParameters.Metric.INGEST);
        return this;
    }

    public NodesStatsRequestBuilder setAdaptiveSelection(boolean adaptiveSelection) {
        this.addOrRemoveMetric(adaptiveSelection, NodesStatsRequestParameters.Metric.ADAPTIVE_SELECTION);
        return this;
    }

    public NodesStatsRequestBuilder setScriptCache(boolean scriptCache) {
        this.addOrRemoveMetric(scriptCache, NodesStatsRequestParameters.Metric.SCRIPT_CACHE);
        return this;
    }

    public NodesStatsRequestBuilder setIndexingPressure(boolean indexingPressure) {
        this.addOrRemoveMetric(indexingPressure, NodesStatsRequestParameters.Metric.INDEXING_PRESSURE);
        return this;
    }

    public NodesStatsRequestBuilder setRepositoryStats(boolean repositoryStats) {
        this.addOrRemoveMetric(repositoryStats, NodesStatsRequestParameters.Metric.REPOSITORIES);
        return this;
    }

    public NodesStatsRequestBuilder setAllocationStats(boolean allocationStats) {
        this.addOrRemoveMetric(allocationStats, NodesStatsRequestParameters.Metric.ALLOCATIONS);
        return this;
    }

    private void addOrRemoveMetric(boolean includeMetric, NodesStatsRequestParameters.Metric metric) {
        if (includeMetric) {
            ((NodesStatsRequest)this.request).addMetric(metric);
        } else {
            ((NodesStatsRequest)this.request).removeMetric(metric);
        }
    }
}

