/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.textstructure.structurefinder.FieldStats;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureUtils;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;
import org.elasticsearch.xpack.textstructure.structurefinder.TimestampFormatFinder;

public class NdJsonTextStructureFinder
implements TextStructureFinder {
    private final List<String> sampleMessages;
    private final TextStructure structure;

    static NdJsonTextStructureFinder makeNdJsonTextStructureFinder(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException {
        ArrayList sampleRecords = new ArrayList();
        List<String> sampleMessages = Arrays.asList(sample.split("\n"));
        for (String sampleMessage : sampleMessages) {
            XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, sampleMessage);
            try {
                sampleRecords.add(parser.mapOrdered());
                timeoutChecker.check("NDJSON parsing");
            }
            finally {
                if (parser == null) continue;
                parser.close();
            }
        }
        TextStructure.Builder structureBuilder = new TextStructure.Builder(TextStructure.Format.NDJSON).setCharset(charsetName).setHasByteOrderMarker(hasByteOrderMarker).setSampleStart(sampleMessages.stream().limit(2L).collect(Collectors.joining("\n", "", "\n"))).setNumLinesAnalyzed(sampleMessages.size()).setNumMessagesAnalyzed(sampleRecords.size());
        Tuple<String, TimestampFormatFinder> timeField = TextStructureUtils.guessTimestampField(explanation, sampleRecords, overrides, timeoutChecker);
        if (timeField != null) {
            boolean needClientTimeZone = ((TimestampFormatFinder)timeField.v2()).hasTimezoneDependentParsing();
            structureBuilder.setTimestampField((String)timeField.v1()).setJodaTimestampFormats(((TimestampFormatFinder)timeField.v2()).getJodaTimestampFormats()).setJavaTimestampFormats(((TimestampFormatFinder)timeField.v2()).getJavaTimestampFormats()).setNeedClientTimezone(needClientTimeZone).setEcsCompatibility(overrides.getEcsCompatibility()).setIngestPipeline(TextStructureUtils.makeIngestPipelineDefinition(null, Collections.emptyMap(), null, Collections.emptyMap(), (String)timeField.v1(), ((TimestampFormatFinder)timeField.v2()).getJavaTimestampFormats(), needClientTimeZone, ((TimestampFormatFinder)timeField.v2()).needNanosecondPrecision(), overrides.getEcsCompatibility()));
        }
        Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> mappingsAndFieldStats = TextStructureUtils.guessMappingsAndCalculateFieldStats(explanation, sampleRecords, timeoutChecker, overrides.getTimestampFormat());
        Map fieldMappings = (Map)mappingsAndFieldStats.v1();
        if (timeField != null) {
            fieldMappings.put("@timestamp", ((TimestampFormatFinder)timeField.v2()).getEsDateMappingTypeWithoutFormat());
        }
        if (mappingsAndFieldStats.v2() != null) {
            structureBuilder.setFieldStats((Map)mappingsAndFieldStats.v2());
        }
        TextStructure structure = structureBuilder.setMappings(Collections.singletonMap("properties", fieldMappings)).setExplanation(explanation).build();
        return new NdJsonTextStructureFinder(sampleMessages, structure);
    }

    private NdJsonTextStructureFinder(List<String> sampleMessages, TextStructure structure) {
        this.sampleMessages = Collections.unmodifiableList(sampleMessages);
        this.structure = structure;
    }

    @Override
    public List<String> getSampleMessages() {
        return this.sampleMessages;
    }

    @Override
    public TextStructure getStructure() {
        return this.structure;
    }
}

