/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.custom.CustomRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.custom.CustomSecretSettings;
import org.elasticsearch.xpack.inference.services.custom.CustomServiceSettings;
import org.elasticsearch.xpack.inference.services.custom.CustomTaskSettings;

public class CustomModel
extends Model {
    private final CustomRateLimitServiceSettings rateLimitServiceSettings;

    public CustomModel(ModelConfigurations configurations, ModelSecrets secrets, CustomRateLimitServiceSettings rateLimitServiceSettings) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
    }

    public static CustomModel of(CustomModel model, Map<String, Object> taskSettings) {
        CustomTaskSettings requestTaskSettings = CustomTaskSettings.fromMap(taskSettings);
        return new CustomModel(model, CustomTaskSettings.of(model.getTaskSettings(), requestTaskSettings));
    }

    public CustomModel(String inferenceId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceId, taskType, service, CustomServiceSettings.fromMap(serviceSettings, context, taskType, inferenceId), CustomTaskSettings.fromMap(taskSettings), CustomSecretSettings.fromMap(secrets));
    }

    public CustomModel(String inferenceId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, @Nullable ChunkingSettings chunkingSettings, ConfigurationParseContext context) {
        this(inferenceId, taskType, service, CustomServiceSettings.fromMap(serviceSettings, context, taskType, inferenceId), CustomTaskSettings.fromMap(taskSettings), CustomSecretSettings.fromMap(secrets), chunkingSettings);
    }

    CustomModel(String inferenceId, TaskType taskType, String service, CustomServiceSettings serviceSettings, CustomTaskSettings taskSettings, @Nullable CustomSecretSettings secretSettings) {
        this(new ModelConfigurations(inferenceId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secretSettings), serviceSettings);
    }

    CustomModel(String inferenceId, TaskType taskType, String service, CustomServiceSettings serviceSettings, CustomTaskSettings taskSettings, @Nullable CustomSecretSettings secretSettings, @Nullable ChunkingSettings chunkingSettings) {
        this(new ModelConfigurations(inferenceId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings, chunkingSettings), new ModelSecrets((SecretSettings)secretSettings), serviceSettings);
    }

    protected CustomModel(CustomModel model, TaskSettings taskSettings) {
        super((Model)model, taskSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    protected CustomModel(CustomModel model, ServiceSettings serviceSettings) {
        super((Model)model, serviceSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    public CustomServiceSettings getServiceSettings() {
        return (CustomServiceSettings)super.getServiceSettings();
    }

    public CustomTaskSettings getTaskSettings() {
        return (CustomTaskSettings)super.getTaskSettings();
    }

    public CustomSecretSettings getSecretSettings() {
        return (CustomSecretSettings)super.getSecretSettings();
    }

    public CustomRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }
}

