/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.client;

import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.amazon.AwsSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockStreamingChatProcessor;
import org.reactivestreams.FlowAdapters;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeException;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class AmazonBedrockInferenceClient
extends AmazonBedrockBaseClient {
    static final int CLIENT_CACHE_EXPIRY_MINUTES = 5;
    private static final Duration DEFAULT_CLIENT_TIMEOUT_MS;
    private final BedrockRuntimeAsyncClient internalClient;
    private final ThreadPool threadPool;

    public static AmazonBedrockBaseClient create(AmazonBedrockModel model, @Nullable TimeValue timeout, ThreadPool threadPool) {
        try {
            return new AmazonBedrockInferenceClient(model, timeout, threadPool);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to create Amazon Bedrock Client", (Throwable)e, new Object[0]);
        }
    }

    protected AmazonBedrockInferenceClient(AmazonBedrockModel model, @Nullable TimeValue timeout, ThreadPool threadPool) {
        super(model, timeout);
        this.internalClient = this.createAmazonBedrockClient(model, timeout);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.setExpiryTimestamp();
    }

    @Override
    public void converse(ConverseRequest converseRequest, ActionListener<ConverseResponse> responseListener) throws ElasticsearchException {
        try {
            CompletableFuture responseFuture = this.internalClient.converse(converseRequest);
            responseListener.onResponse((Object)((ConverseResponse)responseFuture.get()));
        }
        catch (Exception e) {
            this.onFailure(responseListener, e, "converse");
        }
    }

    @Override
    public Flow.Publisher<? extends InferenceServiceResults.Result> converseStream(ConverseStreamRequest request) throws ElasticsearchException {
        AmazonBedrockStreamingChatProcessor awsResponseProcessor = new AmazonBedrockStreamingChatProcessor(this.threadPool);
        this.internalClient.converseStream(request, ((ConverseStreamResponseHandler.Builder)ConverseStreamResponseHandler.builder().subscriber(() -> FlowAdapters.toSubscriber((Flow.Subscriber)awsResponseProcessor))).build()).exceptionally(e -> {
            awsResponseProcessor.onError((Throwable)e);
            return null;
        });
        return awsResponseProcessor;
    }

    private void onFailure(ActionListener<?> listener, Throwable t, String method) {
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)t);
        Throwable unwrappedException = t;
        if (t instanceof CompletionException || t instanceof ExecutionException) {
            Throwable throwable = unwrappedException = t.getCause() != null ? t.getCause() : t;
        }
        if (unwrappedException instanceof BedrockRuntimeException) {
            BedrockRuntimeException amazonBedrockRuntimeException = (BedrockRuntimeException)unwrappedException;
            listener.onFailure((Exception)((Object)new ElasticsearchException(Strings.format((String)"AmazonBedrock %s failure: [%s]", (Object[])new Object[]{method, amazonBedrockRuntimeException.getMessage()}), (Throwable)amazonBedrockRuntimeException, new Object[0])));
        } else if (unwrappedException instanceof ElasticsearchException) {
            ElasticsearchException elasticsearchException = (ElasticsearchException)unwrappedException;
            listener.onFailure((Exception)((Object)elasticsearchException));
        } else {
            listener.onFailure((Exception)((Object)new ElasticsearchException(Strings.format((String)"Amazon Bedrock %s call failed", (Object[])new Object[]{method}), unwrappedException, new Object[0])));
        }
    }

    @Override
    public void invokeModel(InvokeModelRequest invokeModelRequest, ActionListener<InvokeModelResponse> responseListener) throws ElasticsearchException {
        try {
            CompletableFuture responseFuture = this.internalClient.invokeModel(invokeModelRequest);
            responseListener.onResponse((Object)((InvokeModelResponse)responseFuture.get()));
        }
        catch (Exception e) {
            this.onFailure(responseListener, e, "invoke model");
        }
    }

    protected BedrockRuntimeAsyncClient createAmazonBedrockClient(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        AwsSecretSettings secretSettings = model.getSecretSettings();
        AmazonBedrockServiceSettings serviceSettings = model.getServiceSettings();
        try {
            SpecialPermission.check();
            return AccessController.doPrivileged(() -> {
                AwsBasicCredentials credentials = AwsBasicCredentials.create((String)secretSettings.accessKey().toString(), (String)secretSettings.secretKey().toString());
                StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
                NettyNioAsyncHttpClient.Builder clientConfig = timeout == null ? NettyNioAsyncHttpClient.builder().connectionTimeout(DEFAULT_CLIENT_TIMEOUT_MS) : NettyNioAsyncHttpClient.builder().connectionTimeout(Duration.ofMillis(timeout.millis()));
                ClientOverrideConfiguration override = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().defaultProfileFileSupplier(() -> ((ProfileFile.Aggregator)ProfileFile.aggregator()).build()).defaultProfileFile(ProfileFile.aggregator().build()).retryPolicy(retryPolicy -> retryPolicy.numRetries(Integer.valueOf(1))).retryStrategy(retryStrategy -> retryStrategy.maxAttempts(1)).build();
                return (BedrockRuntimeAsyncClient)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.of((String)serviceSettings.region()))).httpClientBuilder((SdkAsyncHttpClient.Builder)clientConfig)).overrideConfiguration(override)).build();
            });
        }
        catch (BedrockRuntimeException amazonBedrockRuntimeException) {
            throw new ElasticsearchException(Strings.format((String)"failed to create AmazonBedrockRuntime client: [%s]", (Object[])new Object[]{amazonBedrockRuntimeException.getMessage()}), (Throwable)amazonBedrockRuntimeException, new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to create AmazonBedrockRuntime client", (Throwable)e, new Object[0]);
        }
    }

    private void setExpiryTimestamp() {
        this.expiryTimestamp = this.clock.instant().plus(Duration.ofMinutes(5L));
    }

    @Override
    public boolean isExpired(Instant currentTimestampMs) {
        Objects.requireNonNull(currentTimestampMs);
        return currentTimestampMs.isAfter(this.expiryTimestamp);
    }

    @Override
    public void resetExpiration() {
        this.setExpiryTimestamp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonBedrockInferenceClient that = (AmazonBedrockInferenceClient)o;
        return Objects.equals(this.modelKeysAndRegionHashcode, that.modelKeysAndRegionHashcode);
    }

    public int hashCode() {
        return this.modelKeysAndRegionHashcode;
    }

    @Override
    void close() {
        this.internalClient.close();
    }

    static {
        LoggerFactory.getLogger(AmazonBedrockInferenceClient.class);
        DEFAULT_CLIENT_TIMEOUT_MS = Duration.ofMillis(10000L);
    }
}

