/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.rerank.RerankingRankFeaturePhaseRankShardContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankFeaturePhaseRankCoordinatorContext;

public class TextSimilarityRankBuilder
extends RankBuilder {
    public static final String NAME = "text_similarity_reranker";
    public static final LicensedFeature.Momentary TEXT_SIMILARITY_RERANKER_FEATURE = LicensedFeature.momentary(null, (String)"text-similarity-reranker", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private static final TransportVersion RERANKER_FAILURES_ALLOWED = TransportVersion.fromName((String)"reranker_failures_allowed");
    private final String inferenceId;
    private final String inferenceText;
    private final String field;
    private final Float minScore;
    private final boolean failuresAllowed;

    public TextSimilarityRankBuilder(String field, String inferenceId, String inferenceText, int rankWindowSize, Float minScore, boolean failuresAllowed) {
        super(rankWindowSize);
        this.inferenceId = inferenceId;
        this.inferenceText = inferenceText;
        this.field = field;
        this.minScore = minScore;
        this.failuresAllowed = failuresAllowed;
    }

    public TextSimilarityRankBuilder(StreamInput in) throws IOException {
        super(in);
        this.inferenceId = in.readString();
        this.inferenceText = in.readString();
        this.field = in.readString();
        this.minScore = in.readOptionalFloat();
        this.failuresAllowed = in.getTransportVersion().supports(RERANKER_FAILURES_ALLOWED) ? in.readBoolean() : false;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.inferenceId);
        out.writeString(this.inferenceText);
        out.writeString(this.field);
        out.writeOptionalFloat(this.minScore);
        if (out.getTransportVersion().supports(RERANKER_FAILURES_ALLOWED)) {
            out.writeBoolean(this.failuresAllowed);
        }
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        throw new UnsupportedOperationException("This should not be XContent serialized");
    }

    public boolean isCompoundBuilder() {
        return false;
    }

    public Explanation explainHit(Explanation baseExplanation, RankDoc scoreDoc, List<String> queryNames) {
        if (scoreDoc == null) {
            return baseExplanation;
        }
        if (!baseExplanation.isMatch()) {
            return baseExplanation;
        }
        assert (scoreDoc instanceof RankFeatureDoc) : "ScoreDoc is not an instance of RankFeatureDoc";
        RankFeatureDoc rrfRankDoc = (RankFeatureDoc)scoreDoc;
        return Explanation.match((Number)Float.valueOf(rrfRankDoc.score), (String)("rank after reranking: [" + rrfRankDoc.rank + "] with score: [" + rrfRankDoc.score + "], using inference endpoint: [" + this.inferenceId + "] on document field: [" + this.field + "]"), (Explanation[])new Explanation[]{baseExplanation});
    }

    public QueryPhaseRankShardContext buildQueryPhaseShardContext(List<Query> queries, int from) {
        return null;
    }

    public QueryPhaseRankCoordinatorContext buildQueryPhaseCoordinatorContext(int size, int from) {
        return null;
    }

    public RankFeaturePhaseRankShardContext buildRankFeaturePhaseShardContext() {
        return new RerankingRankFeaturePhaseRankShardContext(this.field);
    }

    public RankFeaturePhaseRankCoordinatorContext buildRankFeaturePhaseCoordinatorContext(int size, int from, Client client) {
        return new TextSimilarityRankFeaturePhaseRankCoordinatorContext(size, from, this.rankWindowSize(), client, this.inferenceId, this.inferenceText, this.minScore, this.failuresAllowed);
    }

    public String field() {
        return this.field;
    }

    public String inferenceId() {
        return this.inferenceId;
    }

    public String inferenceText() {
        return this.inferenceText;
    }

    public Float minScore() {
        return this.minScore;
    }

    public boolean failuresAllowed() {
        return this.failuresAllowed;
    }

    protected boolean doEquals(RankBuilder other) {
        TextSimilarityRankBuilder that = (TextSimilarityRankBuilder)other;
        return Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.inferenceText, that.inferenceText) && Objects.equals(this.field, that.field) && Objects.equals(this.minScore, that.minScore) && this.failuresAllowed == that.failuresAllowed;
    }

    protected int doHashCode() {
        return Objects.hash(this.inferenceId, this.inferenceText, this.field, this.minScore, this.failuresAllowed);
    }
}

