/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.CanMatchPreFilterSearchPhase;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportOpenPointInTimeAction
extends HandledTransportAction<OpenPointInTimeRequest, OpenPointInTimeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportOpenPointInTimeAction.class);
    public static final String OPEN_SHARD_READER_CONTEXT_NAME = "indices:data/read/open_reader_context";
    public static final ActionType<OpenPointInTimeResponse> TYPE = new ActionType("indices:data/read/open_point_in_time");
    private final TransportSearchAction transportSearchAction;
    private final SearchTransportService searchTransportService;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final TransportService transportService;
    private final SearchService searchService;
    private final ClusterService clusterService;

    @Inject
    public TransportOpenPointInTimeAction(TransportService transportService, SearchService searchService, ActionFilters actionFilters, TransportSearchAction transportSearchAction, SearchTransportService searchTransportService, NamedWriteableRegistry namedWriteableRegistry, ClusterService clusterService) {
        super(TYPE.name(), transportService, actionFilters, OpenPointInTimeRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transportService = transportService;
        this.transportSearchAction = transportSearchAction;
        this.searchService = searchService;
        this.searchTransportService = searchTransportService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.clusterService = clusterService;
        transportService.registerRequestHandler(OPEN_SHARD_READER_CONTEXT_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, ShardOpenReaderRequest::new, new ShardOpenReaderRequestHandler());
        TransportActionProxy.registerProxyAction(transportService, OPEN_SHARD_READER_CONTEXT_NAME, false, ShardOpenReaderResponse::new);
    }

    @Override
    protected void doExecute(Task task, OpenPointInTimeRequest request, ActionListener<OpenPointInTimeResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        if (request.allowPartialSearchResults() && clusterState.getMinTransportVersion().before(TransportVersions.V_8_16_0)) {
            listener.onFailure(new ElasticsearchStatusException(Strings.format((String)"The [allow_partial_search_results] parameter cannot be used while the cluster is still upgrading. Please wait until the upgrade is fully completed and try again.", (Object[])new Object[0]), RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        SearchRequest searchRequest = new SearchRequest().indices(request.indices()).indicesOptions(request.indicesOptions()).preference(request.preference()).routing(request.routing()).allowPartialSearchResults(request.allowPartialSearchResults()).source(new SearchSourceBuilder().query(request.indexFilter()));
        searchRequest.setMaxConcurrentShardRequests(request.maxConcurrentShardRequests());
        searchRequest.setCcsMinimizeRoundtrips(false);
        this.transportSearchAction.executeRequest((SearchTask)task, searchRequest, listener.map(r -> {
            assert (r.pointInTimeId() != null) : r;
            return new OpenPointInTimeResponse(r.pointInTimeId(), r.getTotalShards(), r.getSuccessfulShards(), r.getFailedShards(), r.getSkippedShards());
        }), searchListener -> new OpenPointInTimePhase(request, (ActionListener<SearchResponse>)searchListener));
    }

    private class ShardOpenReaderRequestHandler
    implements TransportRequestHandler<ShardOpenReaderRequest> {
        private ShardOpenReaderRequestHandler() {
        }

        @Override
        public void messageReceived(ShardOpenReaderRequest request, TransportChannel channel, Task task) {
            TransportOpenPointInTimeAction.this.searchService.openReaderContext(request.getShardId(), request.keepAlive, new ChannelActionListener(channel).map(ShardOpenReaderResponse::new));
        }
    }

    private final class OpenPointInTimePhase
    implements TransportSearchAction.SearchPhaseProvider {
        private final OpenPointInTimeRequest pitRequest;
        private final ActionListener<SearchResponse> listener;

        OpenPointInTimePhase(OpenPointInTimeRequest pitRequest, ActionListener<SearchResponse> listener) {
            this.pitRequest = pitRequest;
            this.listener = listener;
        }

        @Override
        public void runNewSearchPhase(SearchTask task, SearchRequest searchRequest, Executor executor, List<SearchShardIterator> shardIterators, TransportSearchAction.SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters) {
            if (SearchService.canRewriteToMatchNone(searchRequest.source())) {
                new CanMatchPreFilterSearchPhase(logger, TransportOpenPointInTimeAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, threadPool.executor("search_coordination"), searchRequest, shardIterators, timeProvider, task, false, TransportOpenPointInTimeAction.this.searchService.getCoordinatorRewriteContextProvider(timeProvider::absoluteStartMillis), this.listener.delegateFailureAndWrap((searchResponseActionListener, searchShardIterators) -> this.runOpenPointInTimePhase(task, searchRequest, executor, (List<SearchShardIterator>)searchShardIterators, timeProvider, connectionLookup, clusterState, aliasFilter, concreteIndexBoosts, clusters))).start();
            } else {
                this.runOpenPointInTimePhase(task, searchRequest, executor, shardIterators, timeProvider, connectionLookup, clusterState, aliasFilter, concreteIndexBoosts, clusters);
            }
        }

        void runOpenPointInTimePhase(SearchTask task, SearchRequest searchRequest, Executor executor, List<SearchShardIterator> shardIterators, TransportSearchAction.SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, SearchResponse.Clusters clusters) {
            assert (searchRequest.getMaxConcurrentShardRequests() == this.pitRequest.maxConcurrentShardRequests()) : searchRequest.getMaxConcurrentShardRequests() + " != " + this.pitRequest.maxConcurrentShardRequests();
            new AbstractSearchAsyncAction<SearchPhaseResult>(TransportOpenPointInTimeAction.this.actionName, logger, TransportOpenPointInTimeAction.this.namedWriteableRegistry, TransportOpenPointInTimeAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, executor, searchRequest, this.listener, shardIterators, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardIterators.size()), searchRequest.getMaxConcurrentShardRequests(), clusters){

                @Override
                protected void executePhaseOnShard(SearchShardIterator shardIt, Transport.Connection connection, SearchActionListener<SearchPhaseResult> phaseListener) {
                    TransportOpenPointInTimeAction.this.transportService.sendChildRequest(connection, TransportOpenPointInTimeAction.OPEN_SHARD_READER_CONTEXT_NAME, new ShardOpenReaderRequest(shardIt.shardId(), shardIt.getOriginalIndices(), OpenPointInTimePhase.this.pitRequest.keepAlive()), this.task, new ActionListenerResponseHandler<ShardOpenReaderResponse>(phaseListener, ShardOpenReaderResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
                }

                @Override
                protected SearchPhase getNextPhase() {
                    return new SearchPhase(this.getName()){

                        @Override
                        protected void run() {
                            this.sendSearchResponse(SearchResponseSections.EMPTY_WITH_TOTAL_HITS, results.getAtomicArray());
                        }
                    };
                }

                @Override
                boolean buildPointInTimeFromSearchResults() {
                    return true;
                }
            }.start();
        }
    }

    private static final class ShardOpenReaderResponse
    extends SearchPhaseResult {
        ShardOpenReaderResponse(ShardSearchContextId contextId) {
            this.contextId = contextId;
        }

        ShardOpenReaderResponse(StreamInput in) throws IOException {
            super(in);
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.contextId.writeTo(out);
        }
    }

    private static final class ShardOpenReaderRequest
    extends TransportRequest
    implements IndicesRequest {
        final ShardId shardId;
        final OriginalIndices originalIndices;
        final TimeValue keepAlive;

        ShardOpenReaderRequest(ShardId shardId, OriginalIndices originalIndices, TimeValue keepAlive) {
            this.shardId = shardId;
            this.originalIndices = originalIndices;
            this.keepAlive = keepAlive;
        }

        ShardOpenReaderRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
            this.keepAlive = in.readTimeValue();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
            out.writeTimeValue(this.keepAlive);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Override
        public String[] indices() {
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.originalIndices.indicesOptions();
        }
    }
}

