/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.lucene.LuceneQueryEvaluator;
import org.elasticsearch.compute.lucene.LuceneQueryExpressionEvaluator;
import org.elasticsearch.compute.lucene.LuceneQueryScoreEvaluator;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.ScoreOperator;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.EntryExpression;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Kql;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.TranslationAwareExpressionQuery;
import org.elasticsearch.xpack.esql.score.ExpressionScoreMapper;

public abstract class FullTextFunction
extends org.elasticsearch.xpack.esql.core.expression.function.Function
implements TranslationAware,
PostAnalysisPlanVerificationAware,
EvaluatorMapper,
ExpressionScoreMapper {
    private final Expression query;
    private final QueryBuilder queryBuilder;

    protected FullTextFunction(Source source, Expression query, List<Expression> children, QueryBuilder queryBuilder) {
        super(source, children);
        this.query = query;
        this.queryBuilder = queryBuilder;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.resolveParams();
    }

    protected Expression.TypeResolution resolveParams() {
        return this.resolveQuery(TypeResolutions.ParamOrdinal.DEFAULT);
    }

    protected Expression.TypeResolution resolveQuery(TypeResolutions.ParamOrdinal queryOrdinal) {
        return TypeResolutions.isString((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)queryOrdinal).and(TypeResolutions.isNotNullAndFoldable((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)queryOrdinal));
    }

    public Expression query() {
        return this.query;
    }

    public Object queryAsObject() {
        Object queryAsObject = this.query().fold(FoldContext.small());
        return BytesRefs.toString((Object)queryAsObject);
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public String functionType() {
        return "function";
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.queryBuilder);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.queryBuilder, ((FullTextFunction)obj).queryBuilder) && Objects.equals(this.query, ((FullTextFunction)obj).query);
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return TranslationAware.Translatable.YES;
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return this.queryBuilder != null ? new TranslationAwareExpressionQuery(this.source(), this.queryBuilder) : this.translate(handler);
    }

    public QueryBuilder queryBuilder() {
        return this.queryBuilder;
    }

    protected abstract Query translate(TranslatorHandler var1);

    public abstract Expression replaceQueryBuilder(QueryBuilder var1);

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return FullTextFunction::checkFullTextQueryFunctions;
    }

    private static void checkFullTextQueryFunctions(LogicalPlan plan, Failures failures) {
        if (plan instanceof Filter) {
            Filter f = (Filter)plan;
            Expression condition = f.condition();
            List.of(QueryString.class, Kql.class).forEach(functionClass -> FullTextFunction.checkCommandsBeforeExpression(plan, condition, functionClass, lp -> lp instanceof Filter || lp instanceof OrderBy || lp instanceof EsRelation, fullTextFunction -> "[" + fullTextFunction.functionName() + "] " + fullTextFunction.functionType(), failures));
            FullTextFunction.checkCommandsBeforeExpression(plan, condition, FullTextFunction.class, lp -> !(lp instanceof Limit) && !(lp instanceof Aggregate), m -> "[" + m.functionName() + "] " + m.functionType(), failures);
            FullTextFunction.checkFullTextFunctionsParents(condition, failures);
        } else if (plan instanceof Aggregate) {
            Aggregate agg = (Aggregate)plan;
            FullTextFunction.checkFullTextFunctionsInAggs(agg, failures);
        } else {
            plan.forEachExpression(FullTextFunction.class, ftf -> failures.add(Failure.fail(ftf, "[{}] {} is only supported in WHERE and STATS commands", new Object[]{ftf.functionName(), ftf.functionType()})));
        }
    }

    private static void checkFullTextFunctionsInAggs(Aggregate agg, Failures failures) {
        agg.groupings().forEach(exp -> exp.forEachDown(e -> {
            if (e instanceof FullTextFunction) {
                FullTextFunction ftf = (FullTextFunction)e;
                failures.add(Failure.fail(ftf, "[{}] {} is only supported in WHERE and STATS commands", new Object[]{ftf.functionName(), ftf.functionType()}));
            }
        }));
    }

    private static <E extends Expression> void checkCommandsBeforeExpression(LogicalPlan plan, Expression condition, Class<E> typeToken, Predicate<LogicalPlan> commandCheck, Function<E, String> typeErrorMsgProvider, Failures failures) {
        condition.forEachDown(typeToken, exp -> plan.forEachDown(LogicalPlan.class, lp -> {
            if (!commandCheck.test((LogicalPlan)((Object)lp))) {
                failures.add(Failure.fail(plan, "{} cannot be used after {}", typeErrorMsgProvider.apply(exp), lp.sourceText().split(" ")[0].toUpperCase(Locale.ROOT)));
            }
        }));
    }

    private static void checkFullTextFunctionsParents(Expression condition, Failures failures) {
        FullTextFunction.forEachFullTextFunctionParent(condition, (ftf, parent) -> {
            if (!(parent instanceof FullTextFunction || parent instanceof BinaryLogic || parent instanceof Not)) {
                failures.add(Failure.fail(condition, "Invalid condition [{}]. [{}] {} can't be used with {}", new Object[]{condition.sourceText(), ftf.functionName(), ftf.functionType(), ((org.elasticsearch.xpack.esql.core.expression.function.Function)parent).functionName()}));
            }
        });
    }

    private static FullTextFunction forEachFullTextFunctionParent(Expression condition, BiConsumer<FullTextFunction, Expression> action) {
        if (condition instanceof FullTextFunction) {
            FullTextFunction ftf = (FullTextFunction)condition;
            return ftf;
        }
        for (Expression child : condition.children()) {
            FullTextFunction foundMatchingChild = FullTextFunction.forEachFullTextFunctionParent(child, action);
            if (foundMatchingChild == null) continue;
            action.accept(foundMatchingChild, condition);
            return foundMatchingChild;
        }
        return null;
    }

    public static void fieldVerifier(LogicalPlan plan, FullTextFunction function, Expression field, Failures failures) {
        FieldAttribute fieldAttribute = FullTextFunction.fieldAsFieldAttribute(field);
        if (fieldAttribute == null) {
            plan.forEachExpression(function.getClass(), m -> {
                if (function.children().contains(field)) {
                    failures.add(Failure.fail(field, "[{}] {} cannot operate on [{}], which is not a field from an index mapping", new Object[]{m.functionName(), m.functionType(), field.sourceText()}));
                }
            });
        } else {
            plan.forEachDown(p -> {
                EsRelation esRelation;
                if (p instanceof EsRelation && (esRelation = (EsRelation)((Object)p)).indexMode() != IndexMode.STANDARD && esRelation.outputSet().contains((Object)fieldAttribute)) {
                    failures.add(Failure.fail(field, "[{}] {} cannot operate on [{}], supplied by an index [{}] in non-STANDARD mode [{}]", new Object[]{function.functionName(), function.functionType(), field.sourceText(), esRelation.indexPattern(), esRelation.indexMode()}));
                }
            });
        }
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        List<EsPhysicalOperationProviders.ShardContext> shardContexts = toEvaluator.shardContexts();
        LuceneQueryEvaluator.ShardConfig[] shardConfigs = new LuceneQueryEvaluator.ShardConfig[shardContexts.size()];
        int i = 0;
        for (EsPhysicalOperationProviders.ShardContext shardContext : shardContexts) {
            shardConfigs[i++] = new LuceneQueryEvaluator.ShardConfig(shardContext.toQuery(this.queryBuilder()), shardContext.searcher());
        }
        return new LuceneQueryExpressionEvaluator.Factory(shardConfigs);
    }

    @Override
    public ScoreOperator.ExpressionScorer.Factory toScorer(ExpressionScoreMapper.ToScorer toScorer) {
        List<EsPhysicalOperationProviders.ShardContext> shardContexts = toScorer.shardContexts();
        LuceneQueryEvaluator.ShardConfig[] shardConfigs = new LuceneQueryEvaluator.ShardConfig[shardContexts.size()];
        int i = 0;
        for (EsPhysicalOperationProviders.ShardContext shardContext : shardContexts) {
            shardConfigs[i++] = new LuceneQueryEvaluator.ShardConfig(shardContext.toQuery(this.queryBuilder()), shardContext.searcher());
        }
        return new LuceneQueryScoreEvaluator.Factory(shardConfigs);
    }

    protected static void populateOptionsMap(MapExpression options, Map<String, Object> optionsMap, TypeResolutions.ParamOrdinal paramOrdinal, String sourceText, Map<String, DataType> allowedOptions) throws InvalidArgumentException {
        for (EntryExpression entry : options.entryExpressions()) {
            String string;
            String optionName;
            Expression optionExpr = entry.key();
            Expression valueExpr = entry.value();
            Expression.TypeResolution resolution = TypeResolutions.isFoldable((Expression)optionExpr, (String)sourceText, (TypeResolutions.ParamOrdinal)paramOrdinal).and(TypeResolutions.isFoldable((Expression)valueExpr, (String)sourceText, (TypeResolutions.ParamOrdinal)paramOrdinal));
            if (resolution.unresolved()) {
                throw new InvalidArgumentException(resolution.message(), new Object[0]);
            }
            Object optionExprLiteral = ((Literal)optionExpr).value();
            Object valueExprLiteral = ((Literal)valueExpr).value();
            if (optionExprLiteral instanceof BytesRef) {
                BytesRef br = (BytesRef)optionExprLiteral;
                v0 = br.utf8ToString();
            } else {
                v0 = optionName = optionExprLiteral.toString();
            }
            if (valueExprLiteral instanceof BytesRef) {
                BytesRef br = (BytesRef)valueExprLiteral;
                string = br.utf8ToString();
            } else {
                string = valueExprLiteral.toString();
            }
            String optionValue = string;
            DataType dataType = allowedOptions.get(optionName);
            if (dataType == null) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], expected one of {}", (Object[])new Object[]{optionName, sourceText, allowedOptions.keySet()}), new Object[0]);
            }
            try {
                optionsMap.put(optionName, DataTypeConverter.convert((Object)optionValue, (DataType)dataType));
            }
            catch (InvalidArgumentException e) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], {}", (Object[])new Object[]{optionName, sourceText, e.getMessage()}), new Object[0]);
            }
        }
    }

    protected Expression.TypeResolution resolveOptions(Expression options, TypeResolutions.ParamOrdinal paramOrdinal) {
        if (options != null) {
            Expression.TypeResolution resolution = TypeResolutions.isNotNull((Expression)options, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal);
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isMapExpression((Expression)options, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal);
            if (resolution.unresolved()) {
                return resolution;
            }
            try {
                this.resolvedOptions();
            }
            catch (InvalidArgumentException e) {
                return new Expression.TypeResolution(e.getMessage());
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    protected Map<String, Object> resolvedOptions() throws InvalidArgumentException {
        return Map.of();
    }

    public static String getNameFromFieldAttribute(FieldAttribute fieldAttribute) {
        String fieldName = fieldAttribute.name();
        EsField esField = fieldAttribute.field();
        if (esField instanceof MultiTypeEsField) {
            MultiTypeEsField multiTypeEsField = (MultiTypeEsField)esField;
            fieldName = multiTypeEsField.getName();
        }
        return fieldName;
    }

    public static FieldAttribute fieldAsFieldAttribute(Expression field) {
        FieldAttribute fieldAttribute;
        Expression fieldExpression = field;
        if (fieldExpression instanceof AbstractConvertFunction) {
            AbstractConvertFunction convertFunction = (AbstractConvertFunction)fieldExpression;
            fieldExpression = convertFunction.field();
        }
        return fieldExpression instanceof FieldAttribute ? (fieldAttribute = (FieldAttribute)fieldExpression) : null;
    }
}

