/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.action.PositionToXContent;

final class ResponseXContentUtils {
    ResponseXContentUtils() {
    }

    static Iterator<? extends ToXContent> allColumns(List<ColumnInfoImpl> columns, String name) {
        return ChunkedToXContentHelper.singleChunk((builder, params) -> {
            builder.startArray(name);
            for (ColumnInfo col : columns) {
                col.toXContent(builder, params);
            }
            return builder.endArray();
        });
    }

    static Iterator<? extends ToXContent> nonNullColumns(List<ColumnInfoImpl> columns, boolean[] nullColumns, String name) {
        return ChunkedToXContentHelper.singleChunk((builder, params) -> {
            builder.startArray(name);
            for (int c = 0; c < columns.size(); ++c) {
                if (nullColumns[c]) continue;
                ((ColumnInfoImpl)columns.get(c)).toXContent(builder, params);
            }
            return builder.endArray();
        });
    }

    static Iterator<? extends ToXContent> columnValues(List<ColumnInfoImpl> columns, List<Page> pages, boolean columnar, boolean[] nullColumns) {
        if (pages.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (columnar) {
            return ResponseXContentUtils.columnarValues(columns, pages, nullColumns);
        }
        return ResponseXContentUtils.rowValues(columns, pages, nullColumns);
    }

    static Iterator<? extends ToXContent> columnarValues(List<ColumnInfoImpl> columns, List<Page> pages, boolean[] nullColumns) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap((Iterator)Iterators.forRange((int)0, (int)columns.size(), column -> {
            if (nullColumns != null && nullColumns[column]) {
                return Collections.emptyIterator();
            }
            return Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> builder.startArray()), Iterators.flatMap(pages.iterator(), page -> {
                PositionToXContent toXContent = PositionToXContent.positionToXContent((ColumnInfoImpl)columns.get(column), page.getBlock(column), scratch);
                return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> (builder, params) -> toXContent.positionToXContent(builder, params, position));
            }), ChunkedToXContentHelper.endArray()});
        }), Function.identity());
    }

    static Iterator<? extends ToXContent> rowValues(List<ColumnInfoImpl> columns, List<Page> pages, boolean[] nullColumns) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap(pages.iterator(), page -> {
            int columnCount = columns.size();
            assert (page.getBlockCount() == columnCount) : page.getBlockCount() + " != " + columnCount;
            PositionToXContent[] toXContents = new PositionToXContent[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                Block block = page.getBlock(column);
                toXContents[column] = PositionToXContent.positionToXContent((ColumnInfoImpl)columns.get(column), block, scratch);
            }
            return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> (builder, params) -> {
                builder.startArray();
                for (int c = 0; c < columnCount; ++c) {
                    if (nullColumns != null && nullColumns[c]) continue;
                    toXContents[c].positionToXContent(builder, params, position);
                }
                return builder.endArray();
            });
        });
    }
}

