/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.linear;

import java.io.IOException;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.rank.linear.IdentityScoreNormalizer;
import org.elasticsearch.xpack.rank.linear.ScoreNormalizer;

public class LinearRetrieverComponent
implements ToXContentObject {
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ParseField WEIGHT_FIELD = new ParseField("weight", new String[0]);
    public static final ParseField NORMALIZER_FIELD = new ParseField("normalizer", new String[0]);
    static final float DEFAULT_WEIGHT = 1.0f;
    static final ScoreNormalizer DEFAULT_NORMALIZER = IdentityScoreNormalizer.INSTANCE;
    RetrieverBuilder retriever;
    float weight;
    ScoreNormalizer normalizer;
    static final ConstructingObjectParser<LinearRetrieverComponent, RetrieverParserContext> PARSER = new ConstructingObjectParser("retriever-component", false, args -> {
        RetrieverBuilder retrieverBuilder = (RetrieverBuilder)args[0];
        Float weight = (Float)args[1];
        ScoreNormalizer normalizer = (ScoreNormalizer)args[2];
        return new LinearRetrieverComponent(retrieverBuilder, weight, normalizer);
    });

    public LinearRetrieverComponent(RetrieverBuilder retrieverBuilder, Float weight, ScoreNormalizer normalizer) {
        assert (retrieverBuilder != null);
        this.retriever = retrieverBuilder;
        this.weight = weight == null ? 1.0f : weight.floatValue();
        ScoreNormalizer scoreNormalizer = this.normalizer = normalizer == null ? DEFAULT_NORMALIZER : normalizer;
        if (this.weight < 0.0f) {
            throw new IllegalArgumentException("[weight] must be non-negative");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RETRIEVER_FIELD.getPreferredName(), (ToXContent)this.retriever);
        builder.field(WEIGHT_FIELD.getPreferredName(), this.weight);
        builder.field(NORMALIZER_FIELD.getPreferredName(), this.normalizer.getName());
        return builder;
    }

    public static LinearRetrieverComponent fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        return (LinearRetrieverComponent)PARSER.apply(parser, (Object)context);
    }

    static {
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            RetrieverBuilder innerRetriever = (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, n, c);
            c.trackRetrieverUsage(innerRetriever.getName());
            return innerRetriever;
        }, RETRIEVER_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), WEIGHT_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ScoreNormalizer.valueOf(p.text()), NORMALIZER_FIELD, ObjectParser.ValueType.STRING);
    }
}

