/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.lucene.analysis.miscellaneous.DisableGraphAttribute;

public final class CJKBigramFilterFactory
extends AbstractTokenFilterFactory {
    private final int flags;
    private final boolean outputUnigrams;

    CJKBigramFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name, settings);
        this.outputUnigrams = settings.getAsBoolean("output_unigrams", Boolean.valueOf(false));
        List asArray = settings.getAsList("ignored_scripts");
        HashSet<String> scripts = new HashSet<String>(Arrays.asList("han", "hiragana", "katakana", "hangul"));
        if (asArray != null) {
            scripts.removeAll(asArray);
        }
        int flags = 0;
        for (String script : scripts) {
            if ("han".equals(script)) {
                flags |= 1;
                continue;
            }
            if ("hiragana".equals(script)) {
                flags |= 2;
                continue;
            }
            if ("katakana".equals(script)) {
                flags |= 4;
                continue;
            }
            if (!"hangul".equals(script)) continue;
            flags |= 8;
        }
        this.flags = flags;
    }

    public TokenStream create(TokenStream tokenStream) {
        CJKBigramFilter filter = new CJKBigramFilter(tokenStream, this.flags, this.outputUnigrams);
        if (this.outputUnigrams) {
            filter.addAttribute(DisableGraphAttribute.class);
        }
        return filter;
    }

    public TokenFilterFactory getSynonymFilter() {
        if (this.outputUnigrams) {
            throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
        }
        return this;
    }
}

