/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.SerializationConfig;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.ReflectionUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class IOUtils {
    private static final Field BYTE_ARRAY_BUFFER = ReflectionUtils.findField(ByteArrayInputStream.class, "buf");
    private static final ObjectMapper mapper;

    public static String serializeToJsonString(Object object) {
        String json;
        if (object == null) {
            return "";
        }
        try {
            json = mapper.writeValueAsString(object);
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException("Cannot serialize object: " + object, ex);
        }
        return json;
    }

    public static <T> T deserializeFromJsonString(String data, Class<T> clazz) {
        T object;
        if (!StringUtils.hasLength(data)) {
            return null;
        }
        try {
            object = mapper.readValue(data, clazz);
        }
        catch (IOException e) {
            throw new EsHadoopSerializationException("Cannot deserialize string: [" + data + "]", e);
        }
        return object;
    }

    public static String propsToString(Properties props) {
        StringWriter sw = new StringWriter();
        if (props != null) {
            try {
                props.store(sw, "");
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException(ex);
            }
        }
        return sw.toString();
    }

    public static Properties propsFromString(String source) {
        Properties copy = new Properties();
        if (source != null) {
            try {
                copy.load(new StringReader(source));
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException(ex);
            }
        }
        return copy;
    }

    public static BytesArray asBytes(InputStream in) throws IOException {
        BytesArray ba = IOUtils.unwrapStreamBuffer(in);
        if (ba != null) {
            return ba;
        }
        return IOUtils.asBytes(new BytesArray(in.available()), in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesArray asBytes(BytesArray ba, InputStream in) throws IOException {
        BytesArray buf = IOUtils.unwrapStreamBuffer(in);
        if (buf != null) {
            ba.bytes(buf);
            return ba;
        }
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(ba);
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = in.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            bos.close();
        }
        return bos.bytes();
    }

    public static String asString(InputStream in) throws IOException {
        return IOUtils.asBytes(in).toString();
    }

    public static String asStringAlways(InputStream in) {
        if (in == null) {
            return "";
        }
        try {
            return IOUtils.asBytes(in).toString();
        }
        catch (IOException ex) {
            return "";
        }
    }

    public static InputStream open(String resource, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = IOUtils.class.getClassLoader();
        }
        try {
            if (!resource.contains(":")) {
                return loader.getResourceAsStream(resource);
            }
            return new URL(resource).openStream();
        }
        catch (IOException ex) {
            throw new EsHadoopIllegalArgumentException(String.format("Cannot open stream for resource %s", resource), ex);
        }
    }

    public static InputStream open(String location) {
        return IOUtils.open(location, null);
    }

    public static void close(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static byte[] byteArrayInputStreamInternalBuffer(ByteArrayInputStream bais) {
        return (byte[])ReflectionUtils.getField(BYTE_ARRAY_BUFFER, bais);
    }

    private static BytesArray unwrapStreamBuffer(InputStream in) {
        if (in instanceof FastByteArrayInputStream) {
            return ((FastByteArrayInputStream)in).data;
        }
        if (in instanceof ByteArrayInputStream) {
            return new BytesArray(IOUtils.byteArrayInputStreamInternalBuffer((ByteArrayInputStream)in));
        }
        return null;
    }

    public static String toCanonicalFilePath(URL fileURL) throws URISyntaxException, IOException {
        String canonicalString;
        String springBootInnerJarFilePath;
        if (fileURL == null) {
            return null;
        }
        if (!"jar".equals(fileURL.getProtocol()) && !"file".equals(fileURL.getProtocol())) {
            return null;
        }
        if ("jar".equals(fileURL.getProtocol())) {
            JarURLConnection jarURLConnection = (JarURLConnection)fileURL.openConnection();
            fileURL = jarURLConnection.getJarFileURL();
        }
        if ("jar".equals(fileURL.getProtocol())) {
            JarURLConnection jarURLConnection = (JarURLConnection)fileURL.openConnection();
            springBootInnerJarFilePath = jarURLConnection.getEntryName();
            fileURL = jarURLConnection.getJarFileURL();
        } else {
            springBootInnerJarFilePath = null;
        }
        if ("file".equals(fileURL.getProtocol())) {
            URI fileURI = fileURL.toURI();
            File file = new File(fileURI);
            File canonicalFile = file.getCanonicalFile();
            canonicalString = canonicalFile.toURI().toString();
            if (springBootInnerJarFilePath != null) {
                canonicalString = "jar:" + canonicalString + "!/" + springBootInnerJarFilePath;
            }
        } else {
            canonicalString = fileURL.toString();
        }
        return canonicalString;
    }

    static {
        ReflectionUtils.makeAccessible(BYTE_ARRAY_BUFFER);
        mapper = new ObjectMapper().configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
    }
}

