/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class IngestConverter {
    public static String dotsToSquareBrackets(String content) {
        Pattern pattern = Pattern.compile("\\(\\?:%\\{.*\\|-\\)");
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> tokens = new ArrayList<String>();
        String right = content;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String matchContent = content.substring(start, end);
            right = content.substring(end);
            tokens.add(IngestConverter.tokenDotsToSquareBrackets(content.substring(0, start)));
            tokens.add(matchContent);
        }
        tokens.add(IngestConverter.tokenDotsToSquareBrackets(right));
        return String.join((CharSequence)"", tokens);
    }

    private static String tokenDotsToSquareBrackets(String content) {
        String adjusted = Pattern.compile("([\\w_]+\\.)+[\\w_]+").matcher(content).find() ? content.replaceAll("(\\w*)\\.(\\w*)", "$1][$2").replaceAll("\\[(\\w+)(}|$)", "[$1]$2").replaceAll("\\{(\\w+):(\\w+)]", "{$1:[$2]").replaceAll("^(\\w+)]\\[", "[$1][") : content;
        return adjusted;
    }

    public static String quoteString(String content) {
        return "\"" + content.replace("\"", "\\\"") + "\"";
    }

    public static String wrapInCurly(String content) {
        return "{\n" + content + "\n}";
    }

    public static String createField(String fieldName, String content) {
        return fieldName + " => " + content;
    }

    public static String createHash(String fieldName, String content) {
        return fieldName + " " + IngestConverter.wrapInCurly(content);
    }

    public static String joinHashFields(String ... fields) {
        return String.join((CharSequence)"\n", fields);
    }

    public static String fixIndent(String content) {
        CharSequence[] lines = content.split("\n");
        int count = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (Pattern.compile("(\\{|\\[)$").matcher(lines[i]).find()) {
                lines[i] = IngestConverter.indent((String)lines[i], count);
                ++count;
                continue;
            }
            if (Pattern.compile("(\\}|\\])$").matcher(lines[i]).find()) {
                lines[i] = IngestConverter.indent((String)lines[i], --count);
                continue;
            }
            if (i <= 0 || !Pattern.compile("(=>\\s+\".+\"|,|\\{|\\}|\\[|\\])$").matcher(lines[i - 1]).find()) continue;
            lines[i] = IngestConverter.indent((String)lines[i], count);
        }
        return String.join((CharSequence)"\n", lines);
    }

    private static String indent(String content, int shifts) {
        StringBuilder spacing = new StringBuilder();
        for (int i = 0; i < shifts * 3; ++i) {
            spacing.append(" ");
        }
        return spacing.append(content).toString();
    }

    public static String createPatternArray(String ... patterns) {
        String body = Arrays.stream(patterns).map(IngestConverter::dotsToSquareBrackets).map(IngestConverter::quoteString).collect(Collectors.joining(",\n"));
        return "[\n" + body + "\n]";
    }

    public static String createArray(List<String> ingestArray) {
        String body = ingestArray.stream().map(IngestConverter::quoteString).collect(Collectors.joining(",\n"));
        return "[\n" + body + "\n]";
    }

    public static String createPatternArrayOrField(String ... patterns) {
        return patterns.length == 1 ? IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets(patterns[0])) : IngestConverter.createPatternArray(patterns);
    }

    public static String filterHash(String contents) {
        return IngestConverter.fixIndent(IngestConverter.createHash("filter", contents));
    }

    public static String filtersToFile(String ... filters) {
        return String.join((CharSequence)"\n\n", filters) + "\n";
    }

    public static boolean hasOnFailure(Map<String, Map> processor, String name) {
        List onFailure = (List)processor.get(name).get("on_failure");
        return onFailure != null && !onFailure.isEmpty();
    }

    public static List<Map<String, Map>> getOnFailure(Map<String, Map> processor, String name) {
        return (List)processor.get(name).get("on_failure");
    }

    public static String createTagConditional(String tag, String onFailurePipeline) {
        return "if " + IngestConverter.quoteString(tag) + " in [tags] {\n" + onFailurePipeline + "\n}";
    }

    public static String getElasticsearchOutput() {
        return IngestConverter.fixIndent("output {\nelasticsearch {\nhosts => \"localhost\"\n}\n}");
    }

    public static String getStdinInput() {
        return IngestConverter.fixIndent("input {\nstdin {\n}\n}");
    }

    public static String getStdoutOutput() {
        return IngestConverter.fixIndent("output {\nstdout {\ncodec => \"rubydebug\"\n}\n}");
    }

    public static String appendIoPlugins(List<String> filtersPipeline, boolean appendStdio) {
        String filtersPipelineStr = String.join((CharSequence)"\n", filtersPipeline);
        if (appendStdio) {
            return String.join((CharSequence)"\n", IngestConverter.getStdinInput(), filtersPipelineStr, IngestConverter.getStdoutOutput());
        }
        return String.join((CharSequence)"\n", filtersPipelineStr, IngestConverter.getElasticsearchOutput());
    }
}

