/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.impl.services.reflect.DirectCall;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectMethod;
import org.apache.derby.shared.common.error.StandardException;

public final class ReflectGeneratedClass
extends LoadedGeneratedClass {
    private final Hashtable<String, GeneratedMethod> methodCache = new Hashtable();
    private static final GeneratedMethod[] directs = new GeneratedMethod[10];

    public ReflectGeneratedClass(ClassFactory cf, Class jvmClass) {
        super(cf, jvmClass);
    }

    @Override
    public GeneratedMethod getMethod(String simpleName) throws StandardException {
        GeneratedMethod rm = this.methodCache.get(simpleName);
        if (rm != null) {
            return rm;
        }
        try {
            if (simpleName.length() == 2 && simpleName.startsWith("e")) {
                int id = simpleName.charAt(1) - 48;
                rm = directs[id];
            } else {
                Method m = this.getJVMClass().getMethod(simpleName, null);
                rm = new ReflectMethod(m);
            }
            this.methodCache.put(simpleName, rm);
            return rm;
        }
        catch (NoSuchMethodException nsme) {
            throw StandardException.newException((String)"XBCM3.S", (Throwable)nsme, (Object[])new Object[]{this.getName(), simpleName});
        }
    }

    static {
        for (int i = 0; i < directs.length; ++i) {
            ReflectGeneratedClass.directs[i] = new DirectCall(i);
        }
    }
}

