/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class HasPrivilegesRequestBuilder
extends ActionRequestBuilder<HasPrivilegesRequest, HasPrivilegesResponse> {
    public HasPrivilegesRequestBuilder(ElasticsearchClient client) {
        super(client, (ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)new HasPrivilegesRequest());
    }

    public HasPrivilegesRequestBuilder username(String username) {
        ((HasPrivilegesRequest)this.request).username(username);
        return this;
    }

    public HasPrivilegesRequestBuilder source(String username, BytesReference source, XContentType xContentType) throws IOException {
        AuthorizationEngine.PrivilegesToCheck privilegesToCheck = RoleDescriptor.parsePrivilegesToCheck(username + "/has_privileges", true, source, xContentType);
        ((HasPrivilegesRequest)this.request).username(username);
        ((HasPrivilegesRequest)this.request).privilegesToCheck(privilegesToCheck);
        return this;
    }
}

