/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SampleLongAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SampleLongGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("sample", ElementType.BYTES_REF));
    private final SampleLongAggregator.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final int limit;

    public SampleLongGroupingAggregatorFunction(List<Integer> channels, SampleLongAggregator.GroupingState state, DriverContext driverContext, int limit) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.limit = limit;
    }

    public static SampleLongGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, int limit) {
        return new SampleLongGroupingAggregatorFunction(channels, SampleLongAggregator.initGrouping(driverContext.bigArrays(), limit), driverContext, limit);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final LongBlock valuesBlock = (LongBlock)page.getBlock(this.channels.get(0));
        final LongVector valuesVector = valuesBlock.asVector();
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    SampleLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SampleLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntBlock groupIds) {
                SampleLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SampleLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, LongBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                SampleLongAggregator.combine(this.state, groupId, values.getLong(v));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            SampleLongAggregator.combine(this.state, groupId, values.getLong(groupPosition + positionOffset));
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, LongBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    SampleLongAggregator.combine(this.state, groupId, values.getLong(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, LongVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                SampleLongAggregator.combine(this.state, groupId, values.getLong(groupPosition + positionOffset));
            }
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object sampleUncast = page.getBlock(this.channels.get(0));
        if (sampleUncast.areAllValuesNull()) {
            return;
        }
        BytesRefBlock sample = (BytesRefBlock)sampleUncast;
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            SampleLongAggregator.combineIntermediate(this.state, groupId, sample, groupPosition + positionOffset);
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + String.valueOf(this.getClass()) + "; got " + String.valueOf(input.getClass()));
        }
        SampleLongAggregator.GroupingState inState = ((SampleLongGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        SampleLongAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        blocks[offset] = SampleLongAggregator.evaluateFinal(this.state, selected, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

