/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPercentileDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPercentileIntegerEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPercentileLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvPercentile
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvPercentile", MvPercentile::new);
    private static final double MAX_SAFE_LONG_DOUBLE = Double.longBitsToDouble(0x4330000000000000L);
    private final Expression field;
    private final Expression percentile;

    @FunctionInfo(returnType={"double", "integer", "long"}, description="Converts a multivalued field into a single valued field containing the value at which a certain percentage of observed values occur.", examples={@Example(file="mv_percentile", tag="example")})
    public MvPercentile(Source source, @Param(name="number", type={"double", "integer", "long"}, description="Multivalue expression.") Expression field, @Param(name="percentile", type={"double", "integer", "long"}, description="The percentile to calculate. Must be a number between 0 and 100. Numbers out of range will return a null instead.") Expression percentile) {
        super(source, List.of(field, percentile));
        this.field = field;
        this.percentile = percentile;
    }

    private MvPercentile(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public String getWriteableName() {
        return MvPercentile.ENTRY.name;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.percentile);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field, dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"numeric except unsigned_long"}).and(TypeResolutions.isType((Expression)this.percentile, dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"numeric except unsigned_long"}));
    }

    public boolean foldable() {
        return this.field.foldable() && this.percentile.foldable();
    }

    public final Expression field() {
        return this.field;
    }

    public DataType dataType() {
        return this.field.dataType();
    }

    @Override
    public final EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEval = toEvaluator.apply(this.field);
        EvalOperator.ExpressionEvaluator.Factory percentileEval = Cast.cast(this.source(), this.percentile.dataType(), DataType.DOUBLE, toEvaluator.apply(this.percentile));
        return switch (PlannerUtils.toElementType(this.field.dataType())) {
            case ElementType.INT -> new MvPercentileIntegerEvaluator.Factory(this.source(), fieldEval, percentileEval, d -> new IntSortingScratch());
            case ElementType.LONG -> new MvPercentileLongEvaluator.Factory(this.source(), fieldEval, percentileEval, d -> new LongSortingScratch());
            case ElementType.DOUBLE -> new MvPercentileDoubleEvaluator.Factory(this.source(), fieldEval, percentileEval, d -> new DoubleSortingScratch());
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvPercentile(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvPercentile::new, (Object)this.field, (Object)this.percentile);
    }

    static void process(DoubleBlock.Builder builder, int position, DoubleBlock values, double percentile, DoubleSortingScratch scratch) {
        int valueCount = values.getValueCount(position);
        int firstValueIndex = values.getFirstValueIndex(position);
        if (valueCount == 0) {
            builder.appendNull();
            return;
        }
        if (percentile < 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("Percentile parameter must be a number between 0 and 100, found [" + percentile + "]");
        }
        builder.appendDouble(MvPercentile.calculateDoublePercentile(values, firstValueIndex, valueCount, percentile, scratch));
    }

    static void process(IntBlock.Builder builder, int position, IntBlock values, double percentile, IntSortingScratch scratch) {
        int valueCount = values.getValueCount(position);
        int firstValueIndex = values.getFirstValueIndex(position);
        if (valueCount == 0) {
            builder.appendNull();
            return;
        }
        if (percentile < 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("Percentile parameter must be a number between 0 and 100, found [" + percentile + "]");
        }
        builder.appendInt(MvPercentile.calculateIntPercentile(values, firstValueIndex, valueCount, percentile, scratch));
    }

    static void process(LongBlock.Builder builder, int position, LongBlock values, double percentile, LongSortingScratch scratch) {
        int valueCount = values.getValueCount(position);
        int firstValueIndex = values.getFirstValueIndex(position);
        if (valueCount == 0) {
            builder.appendNull();
            return;
        }
        if (percentile < 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("Percentile parameter must be a number between 0 and 100, found [" + percentile + "]");
        }
        builder.appendLong(MvPercentile.calculateLongPercentile(values, firstValueIndex, valueCount, percentile, scratch));
    }

    static double calculateDoublePercentile(DoubleBlock valuesBlock, int firstValueIndex, int valueCount, double percentile, DoubleSortingScratch scratch) {
        if (valueCount == 1) {
            return valuesBlock.getDouble(firstValueIndex);
        }
        double p = percentile / 100.0;
        double index = p * (double)(valueCount - 1);
        int lowerIndex = (int)index;
        int upperIndex = lowerIndex + 1;
        double fraction = index - (double)lowerIndex;
        if (valuesBlock.mvSortedAscending()) {
            if (percentile == 0.0) {
                return valuesBlock.getDouble(0);
            }
            if (percentile == 100.0) {
                return valuesBlock.getDouble(valueCount - 1);
            }
            assert (lowerIndex >= 0 && upperIndex < valueCount);
            return MvPercentile.calculateDoublePercentile(fraction, valuesBlock.getDouble(firstValueIndex + lowerIndex), valuesBlock.getDouble(firstValueIndex + upperIndex));
        }
        if (percentile == 0.0) {
            double min = Double.POSITIVE_INFINITY;
            for (int i = 0; i < valueCount; ++i) {
                min = Math.min(min, valuesBlock.getDouble(firstValueIndex + i));
            }
            return min;
        }
        if (percentile == 100.0) {
            double max = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < valueCount; ++i) {
                max = Math.max(max, valuesBlock.getDouble(firstValueIndex + i));
            }
            return max;
        }
        if (scratch.values.length < valueCount) {
            scratch.values = new double[ArrayUtil.oversize((int)valueCount, (int)8)];
        }
        for (int i = 0; i < valueCount; ++i) {
            scratch.values[i] = valuesBlock.getDouble(firstValueIndex + i);
        }
        Arrays.sort(scratch.values, 0, valueCount);
        assert (lowerIndex >= 0 && upperIndex < valueCount);
        return MvPercentile.calculateDoublePercentile(fraction, scratch.values[lowerIndex], scratch.values[upperIndex]);
    }

    static int calculateIntPercentile(IntBlock valuesBlock, int firstValueIndex, int valueCount, double percentile, IntSortingScratch scratch) {
        if (valueCount == 1) {
            return valuesBlock.getInt(firstValueIndex);
        }
        double p = percentile / 100.0;
        double index = p * (double)(valueCount - 1);
        int lowerIndex = (int)index;
        int upperIndex = lowerIndex + 1;
        double fraction = index - (double)lowerIndex;
        if (valuesBlock.mvSortedAscending()) {
            if (percentile == 0.0) {
                return valuesBlock.getInt(0);
            }
            if (percentile == 100.0) {
                return valuesBlock.getInt(valueCount - 1);
            }
            assert (lowerIndex >= 0 && upperIndex < valueCount);
            int lowerValue = valuesBlock.getInt(firstValueIndex + lowerIndex);
            int upperValue = valuesBlock.getInt(firstValueIndex + upperIndex);
            long difference = (long)upperValue - (long)lowerValue;
            return lowerValue + (int)(fraction * (double)difference);
        }
        if (percentile == 0.0) {
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < valueCount; ++i) {
                min = Math.min(min, valuesBlock.getInt(firstValueIndex + i));
            }
            return min;
        }
        if (percentile == 100.0) {
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < valueCount; ++i) {
                max = Math.max(max, valuesBlock.getInt(firstValueIndex + i));
            }
            return max;
        }
        if (scratch.values.length < valueCount) {
            scratch.values = new int[ArrayUtil.oversize((int)valueCount, (int)4)];
        }
        for (int i = 0; i < valueCount; ++i) {
            scratch.values[i] = valuesBlock.getInt(firstValueIndex + i);
        }
        Arrays.sort(scratch.values, 0, valueCount);
        assert (lowerIndex >= 0 && upperIndex < valueCount);
        int lowerValue = scratch.values[lowerIndex];
        int upperValue = scratch.values[upperIndex];
        long difference = (long)upperValue - (long)lowerValue;
        return lowerValue + (int)(fraction * (double)difference);
    }

    static long calculateLongPercentile(LongBlock valuesBlock, int firstValueIndex, int valueCount, double percentile, LongSortingScratch scratch) {
        if (valueCount == 1) {
            return valuesBlock.getLong(firstValueIndex);
        }
        double p = percentile / 100.0;
        double index = p * (double)(valueCount - 1);
        int lowerIndex = (int)index;
        int upperIndex = lowerIndex + 1;
        double fraction = index - (double)lowerIndex;
        if (valuesBlock.mvSortedAscending()) {
            if (percentile == 0.0) {
                return valuesBlock.getLong(0);
            }
            if (percentile == 100.0) {
                return valuesBlock.getLong(valueCount - 1);
            }
            assert (lowerIndex >= 0 && upperIndex < valueCount);
            return MvPercentile.calculateLongPercentile(fraction, valuesBlock.getLong(firstValueIndex + lowerIndex), valuesBlock.getLong(firstValueIndex + upperIndex));
        }
        if (percentile == 0.0) {
            long min = Long.MAX_VALUE;
            for (int i = 0; i < valueCount; ++i) {
                min = Math.min(min, valuesBlock.getLong(firstValueIndex + i));
            }
            return min;
        }
        if (percentile == 100.0) {
            long max = Long.MIN_VALUE;
            for (int i = 0; i < valueCount; ++i) {
                max = Math.max(max, valuesBlock.getLong(firstValueIndex + i));
            }
            return max;
        }
        if (scratch.values.length < valueCount) {
            scratch.values = new long[ArrayUtil.oversize((int)valueCount, (int)8)];
        }
        for (int i = 0; i < valueCount; ++i) {
            scratch.values[i] = valuesBlock.getLong(firstValueIndex + i);
        }
        Arrays.sort(scratch.values, 0, valueCount);
        assert (lowerIndex >= 0 && upperIndex < valueCount);
        return MvPercentile.calculateLongPercentile(fraction, scratch.values[lowerIndex], scratch.values[upperIndex]);
    }

    private static long calculateLongPercentile(double fraction, long lowerValue, long upperValue) {
        if ((double)upperValue < MAX_SAFE_LONG_DOUBLE && (double)lowerValue > -MAX_SAFE_LONG_DOUBLE) {
            long difference = upperValue - lowerValue;
            return lowerValue + (long)(fraction * (double)difference);
        }
        BigDecimal lowerValueBigDecimal = new BigDecimal(lowerValue);
        BigDecimal upperValueBigDecimal = new BigDecimal(upperValue);
        BigDecimal difference = upperValueBigDecimal.subtract(lowerValueBigDecimal);
        BigDecimal fractionBigDecimal = new BigDecimal(fraction);
        return lowerValueBigDecimal.add(fractionBigDecimal.multiply(difference)).longValue();
    }

    private static double calculateDoublePercentile(double fraction, double lowerValue, double upperValue) {
        if (lowerValue < 0.0 && upperValue > 0.0) {
            return lowerValue + fraction * upperValue - fraction * lowerValue;
        }
        double difference = upperValue - lowerValue;
        return lowerValue + fraction * difference;
    }

    static class DoubleSortingScratch {
        private static final double[] EMPTY = new double[0];
        public double[] values = EMPTY;

        DoubleSortingScratch() {
        }
    }

    static class IntSortingScratch {
        private static final int[] EMPTY = new int[0];
        public int[] values = EMPTY;

        IntSortingScratch() {
        }
    }

    static class LongSortingScratch {
        private static final long[] EMPTY = new long[0];
        public long[] values = EMPTY;

        LongSortingScratch() {
        }
    }
}

