/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundTo;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble1Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble3Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble4Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDoubleBinarySearchEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDoubleLinearSearchEvaluator;

class RoundToDouble {
    static final RoundTo.Build BUILD = (source, field, points) -> {
        double[] f = points.stream().mapToDouble(p -> ((Number)p).doubleValue()).toArray();
        Arrays.sort(f);
        return switch (f.length) {
            case 1 -> new RoundToDouble1Evaluator.Factory(source, field, f[0]);
            case 2 -> new RoundToDouble2Evaluator.Factory(source, field, f[0], f[1]);
            case 3 -> new RoundToDouble3Evaluator.Factory(source, field, f[0], f[1], f[2]);
            case 4 -> new RoundToDouble4Evaluator.Factory(source, field, f[0], f[1], f[2], f[3]);
            case 5, 6, 7, 8, 9, 10 -> new RoundToDoubleLinearSearchEvaluator.Factory(source, field, f);
            default -> new RoundToDoubleBinarySearchEvaluator.Factory(source, field, f);
        };
    };

    RoundToDouble() {
    }

    static double processLinear(double field, double[] points) {
        for (int i = 1; i < points.length; ++i) {
            if (!(field < points[i])) continue;
            return points[i - 1];
        }
        return points[points.length - 1];
    }

    static double process(double field, double[] points) {
        int idx = Arrays.binarySearch(points, field);
        return points[idx >= 0 ? idx : Math.max(0, -idx - 2)];
    }

    static double process(double field, double p0) {
        return p0;
    }

    static double process(double field, double p0, double p1) {
        if (field < p1) {
            return p0;
        }
        return p1;
    }

    static double process(double field, double p0, double p1, double p2) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        return p2;
    }

    static double process(double field, double p0, double p1, double p2, double p3) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        return p3;
    }
}

