/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.plugins.pipeline.AbstractPipelineBus;
import org.logstash.plugins.pipeline.AddressState;
import org.logstash.plugins.pipeline.PipelineBus;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.PipelineOutput;

class PipelineBusV1
extends AbstractPipelineBus
implements PipelineBus {
    final ConcurrentHashMap<String, AddressState> addressStates = new ConcurrentHashMap();
    final ConcurrentHashMap<PipelineOutput, ConcurrentHashMap<String, AddressState>> outputsToAddressStates = new ConcurrentHashMap();
    volatile boolean blockOnUnlisten = false;
    private static final Logger logger = LogManager.getLogger(PipelineBusV1.class);

    PipelineBusV1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEvents(PipelineOutput sender, Collection<JrubyEventExtLibrary.RubyEvent> events, boolean ensureDelivery) {
        if (events.isEmpty()) {
            return;
        }
        PipelineOutput pipelineOutput = sender;
        synchronized (pipelineOutput) {
            ConcurrentHashMap<String, AddressState> addressesToInputs = this.outputsToAddressStates.get(sender);
            JrubyEventExtLibrary.RubyEvent[] orderedEvents = events.toArray(new JrubyEventExtLibrary.RubyEvent[0]);
            addressesToInputs.forEach((address, addressState) -> PipelineBusV1.doSendEvents(orderedEvents, addressState.getReadOnlyView(), ensureDelivery));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSender(PipelineOutput output, Iterable<String> addresses) {
        PipelineOutput pipelineOutput = output;
        synchronized (pipelineOutput) {
            addresses.forEach(address -> this.addressStates.compute((String)address, (k, value) -> {
                AddressState state = value != null ? value : new AddressState((String)address);
                state.addOutput(output);
                return state;
            }));
            this.updateOutputReceivers(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSender(PipelineOutput output, Iterable<String> addresses) {
        PipelineOutput pipelineOutput = output;
        synchronized (pipelineOutput) {
            addresses.forEach(address -> this.addressStates.computeIfPresent((String)address, (k, state) -> {
                state.removeOutput(output);
                if (state.isEmpty()) {
                    return null;
                }
                return state;
            }));
            this.outputsToAddressStates.remove(output);
        }
    }

    private void updateOutputReceivers(PipelineOutput output) {
        this.outputsToAddressStates.compute(output, (k, value) -> {
            ConcurrentHashMap outputAddressToInputMapping = value != null ? value : new ConcurrentHashMap();
            this.addressStates.forEach((address, state) -> {
                if (state.hasOutput(output)) {
                    outputAddressToInputMapping.put(address, state);
                }
            });
            return outputAddressToInputMapping;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean listen(PipelineInput input, String address) {
        PipelineInput pipelineInput = input;
        synchronized (pipelineInput) {
            boolean[] result = new boolean[1];
            this.addressStates.compute(address, (k, value) -> {
                AddressState state;
                AddressState addressState = state = value != null ? value : new AddressState(address);
                if (state.assignInputIfMissing(input)) {
                    state.getOutputs().forEach(this::updateOutputReceivers);
                    result[0] = true;
                } else {
                    result[0] = false;
                }
                return state;
            });
            return result[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlisten(PipelineInput input, String address) throws InterruptedException {
        PipelineInput pipelineInput = input;
        synchronized (pipelineInput) {
            if (this.blockOnUnlisten) {
                this.unlistenBlock(input, address);
            } else {
                this.unlistenNonblock(input, address);
            }
        }
    }

    void unlistenBlock(PipelineInput input, String address) throws InterruptedException {
        boolean[] waiting = new boolean[]{true};
        while (true) {
            this.addressStates.compute(address, (k, state) -> {
                if (state == null) {
                    waiting[0] = false;
                    return null;
                }
                Set<PipelineOutput> outputs = state.getOutputs();
                if (outputs.isEmpty()) {
                    state.unassignInput(input);
                    waiting[0] = false;
                    return null;
                }
                logger.info(() -> String.format("input `%s` is not ready to unlisten from `%s` because the address still has attached senders (%s)", input.getId(), address, outputs.stream().map(PipelineOutput::getId).collect(Collectors.toSet())));
                return state;
            });
            if (!waiting[0]) break;
            Thread.sleep(100L);
        }
    }

    void unlistenNonblock(PipelineInput input, String address) {
        this.addressStates.computeIfPresent(address, (k, state) -> {
            state.unassignInput(input);
            state.getOutputs().forEach(this::updateOutputReceivers);
            return state.isEmpty() ? null : state;
        });
    }

    @Override
    public void setBlockOnUnlisten(boolean blockOnUnlisten) {
        this.blockOnUnlisten = blockOnUnlisten;
    }

    @VisibleForTesting
    static class Testable
    extends PipelineBusV1
    implements PipelineBus.Testable {
        Testable() {
        }

        @Override
        @VisibleForTesting
        public boolean isBlockOnUnlisten() {
            return this.blockOnUnlisten;
        }

        @Override
        @VisibleForTesting
        public Optional<AddressState.ReadOnly> getAddressState(String address) {
            return Optional.ofNullable((AddressState)this.addressStates.get(address)).map(AddressState::getReadOnlyView);
        }

        @Override
        @VisibleForTesting
        public Optional<Set<AddressState.ReadOnly>> getAddressStates(PipelineOutput sender) {
            return Optional.ofNullable((ConcurrentHashMap)this.outputsToAddressStates.get(sender)).map(ConcurrentHashMap::values).map(as -> as.stream().map(AddressState::getReadOnlyView).collect(Collectors.toSet()));
        }
    }
}

