/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ParseField;

@Deprecated
public enum ValueType implements Writeable
{
    STRING(1, "string", "string", CoreValuesSourceType.KEYWORD, DocValueFormat.RAW),
    LONG(2, "byte|short|integer|long", "long", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DOUBLE(3, "float|double", "double", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    NUMBER(4, "number", "number", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DATE(5, "date", "date", CoreValuesSourceType.DATE, new DocValueFormat.DateTime(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, ZoneOffset.UTC, DateFieldMapper.Resolution.MILLISECONDS)),
    IP(6, "ip", "ip", CoreValuesSourceType.IP, DocValueFormat.IP),
    NUMERIC(7, "numeric", "numeric", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    GEOPOINT(8, "geo_point", "geo_point", CoreValuesSourceType.GEOPOINT, DocValueFormat.GEOHASH),
    BOOLEAN(9, "boolean", "boolean", CoreValuesSourceType.BOOLEAN, DocValueFormat.BOOLEAN),
    RANGE(10, "range", "range", CoreValuesSourceType.RANGE, DocValueFormat.RAW);

    final String description;
    final ValuesSourceType valuesSourceType;
    final DocValueFormat defaultFormat;
    private final byte id;
    private final String preferredName;
    public static final ParseField VALUE_TYPE;
    private static final Set<ValueType> numericValueTypes;
    private static final Set<ValueType> stringValueTypes;

    private ValueType(byte id, String description, String preferredName, ValuesSourceType valuesSourceType, DocValueFormat defaultFormat) {
        this.id = id;
        this.description = description;
        this.preferredName = preferredName;
        this.valuesSourceType = valuesSourceType;
        this.defaultFormat = defaultFormat;
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public boolean isA(ValueType valueType) {
        if (numericValueTypes.contains(this)) {
            return numericValueTypes.contains(valueType);
        }
        if (stringValueTypes.contains(this)) {
            return stringValueTypes.contains(valueType);
        }
        return this.equals(valueType);
    }

    public boolean isNotA(ValueType valueType) {
        return !this.isA(valueType);
    }

    public static ValueType lenientParse(String type) {
        return switch (type) {
            case "string" -> STRING;
            case "double", "float" -> DOUBLE;
            case "number", "numeric", "long", "integer", "short", "byte" -> LONG;
            case "date" -> DATE;
            case "ip" -> IP;
            case "boolean" -> BOOLEAN;
            default -> null;
        };
    }

    public String toString() {
        return this.description;
    }

    public static ValueType readFromStream(StreamInput in) throws IOException {
        byte id = in.readByte();
        for (ValueType valueType : ValueType.values()) {
            if (id != valueType.id) continue;
            return valueType;
        }
        throw new IOException("No ValueType found for id [" + id + "]");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    static {
        VALUE_TYPE = new ParseField("value_type", "valueType");
        numericValueTypes = Set.of(DOUBLE, DATE, LONG, NUMBER, NUMERIC, BOOLEAN);
        stringValueTypes = Set.of(STRING, IP);
    }
}

