/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.admin.indices.RestCreateIndexAction;

public class RestPutIndexTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutIndexTemplateAction.class);
    public static final String DEPRECATION_WARNING = "Legacy index templates are deprecated in favor of composable templates.";
    private static final RestApiVersion DEPRECATION_VERSION = RestApiVersion.V_8;
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying include_type_name in put index template requests is deprecated. The parameter will be removed in the next major version.";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder(RestRequest.Method.POST, "/_template/{name}").deprecated(DEPRECATION_WARNING, Level.WARN, DEPRECATION_VERSION).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/_template/{name}").deprecated(DEPRECATION_WARNING, Level.WARN, DEPRECATION_VERSION).build());
    }

    @Override
    public String getName() {
        return "put_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutIndexTemplateRequest putRequest = new PutIndexTemplateRequest(request.param("name"));
        if (request.getRestApiVersion() == RestApiVersion.V_7 && request.hasParam("template")) {
            deprecationLogger.compatibleCritical("template_parameter_deprecation", "Deprecated parameter [template] used, replaced by [index_patterns]", new Object[0]);
            putRequest.patterns(List.of(request.param("template")));
        } else {
            putRequest.patterns(Arrays.asList(request.paramAsStringArray("index_patterns", Strings.EMPTY_ARRAY)));
        }
        putRequest.order(request.paramAsInt("order", putRequest.order()));
        putRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        putRequest.create(request.paramAsBoolean("create", false));
        putRequest.cause(request.param("cause", ""));
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (request.getRestApiVersion() == RestApiVersion.V_7) {
            boolean includeTypeName;
            if (request.hasParam("include_type_name")) {
                deprecationLogger.compatibleCritical("put_index_template_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            }
            sourceAsMap = (includeTypeName = request.paramAsBoolean("include_type_name", false)) ? RestCreateIndexAction.prepareMappingsV7(sourceAsMap, request) : RestCreateIndexAction.prepareMappings(sourceAsMap);
        } else {
            sourceAsMap = RestCreateIndexAction.prepareMappings(sourceAsMap);
        }
        if (request.getRestApiVersion() == RestApiVersion.V_7 && sourceAsMap.containsKey("template")) {
            deprecationLogger.compatibleCritical("template_field_deprecation", "Deprecated field [template] used, replaced by [index_patterns]", new Object[0]);
            putRequest.patterns(List.of((String)sourceAsMap.remove("template")));
        }
        putRequest.source(sourceAsMap);
        return channel -> client.admin().indices().putTemplate(putRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

