/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class SplitProcessor
extends AbstractProcessor {
    public static final String TYPE = "split";
    private final String field;
    private final String separator;
    private final boolean ignoreMissing;
    private final boolean preserveTrailing;
    private final String targetField;

    SplitProcessor(String tag, String description, String field, String separator, boolean ignoreMissing, boolean preserveTrailing, String targetField) {
        super(tag, description);
        this.field = field;
        this.separator = separator;
        this.ignoreMissing = ignoreMissing;
        this.preserveTrailing = preserveTrailing;
        this.targetField = targetField;
    }

    String getField() {
        return this.field;
    }

    String getSeparator() {
        return this.separator;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    boolean isPreserveTrailing() {
        return this.preserveTrailing;
    }

    String getTargetField() {
        return this.targetField;
    }

    @Override
    public IngestDocument execute(IngestDocument document) {
        String oldVal = document.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (oldVal == null && this.ignoreMissing) {
            return document;
        }
        if (oldVal == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot split.");
        }
        String[] strings = oldVal.split(this.separator, this.preserveTrailing ? -1 : 0);
        ArrayList splitList = new ArrayList(strings.length);
        Collections.addAll(splitList, strings);
        document.setFieldValue(this.targetField, splitList);
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static class Factory
    implements Processor.Factory {
        @Override
        public SplitProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty(SplitProcessor.TYPE, processorTag, config, "field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(SplitProcessor.TYPE, processorTag, config, "ignore_missing", false);
            boolean preserveTrailing = ConfigurationUtils.readBooleanProperty(SplitProcessor.TYPE, processorTag, config, "preserve_trailing", false);
            String targetField = ConfigurationUtils.readStringProperty(SplitProcessor.TYPE, processorTag, config, "target_field", field);
            String separator = ConfigurationUtils.readStringProperty(SplitProcessor.TYPE, processorTag, config, "separator");
            return new SplitProcessor(processorTag, description, field, separator, ignoreMissing, preserveTrailing, targetField);
        }
    }
}

