/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycleDownsampling;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamLifecycle
implements JsonpSerializable {
    @Nullable
    private final Time dataRetention;
    @Nullable
    private final DataStreamLifecycleDownsampling downsampling;
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<DataStreamLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamLifecycle::setupDataStreamLifecycleDeserializer);

    protected DataStreamLifecycle(AbstractBuilder<?> builder) {
        this.dataRetention = ((AbstractBuilder)builder).dataRetention;
        this.downsampling = ((AbstractBuilder)builder).downsampling;
        this.enabled = ((AbstractBuilder)builder).enabled;
    }

    public static DataStreamLifecycle dataStreamLifecycleOf(Function<Builder, ObjectBuilder<DataStreamLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time dataRetention() {
        return this.dataRetention;
    }

    @Nullable
    public final DataStreamLifecycleDownsampling downsampling() {
        return this.downsampling;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataRetention != null) {
            generator.writeKey("data_retention");
            this.dataRetention.serialize(generator, mapper);
        }
        if (this.downsampling != null) {
            generator.writeKey("downsampling");
            this.downsampling.serialize(generator, mapper);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupDataStreamLifecycleDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::dataRetention, Time._DESERIALIZER, "data_retention");
        op.add(AbstractBuilder::downsampling, DataStreamLifecycleDownsampling._DESERIALIZER, "downsampling");
        op.add(AbstractBuilder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Time dataRetention;
        @Nullable
        private DataStreamLifecycleDownsampling downsampling;
        @Nullable
        private Boolean enabled;

        public final BuilderT dataRetention(@Nullable Time value) {
            this.dataRetention = value;
            return (BuilderT)this.self();
        }

        public final BuilderT dataRetention(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.dataRetention(fn.apply(new Time.Builder()).build());
        }

        public final BuilderT downsampling(@Nullable DataStreamLifecycleDownsampling value) {
            this.downsampling = value;
            return (BuilderT)this.self();
        }

        public final BuilderT downsampling(Function<DataStreamLifecycleDownsampling.Builder, ObjectBuilder<DataStreamLifecycleDownsampling>> fn) {
            return this.downsampling(fn.apply(new DataStreamLifecycleDownsampling.Builder()).build());
        }

        public final BuilderT enabled(@Nullable Boolean value) {
            this.enabled = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<DataStreamLifecycle> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamLifecycle build() {
            this._checkSingleUse();
            return new DataStreamLifecycle(this);
        }
    }
}

