/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.GeometryFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.GeoShapeScriptFieldData;
import org.elasticsearch.xpack.spatial.index.mapper.GeoShapeWithDocValuesFieldMapper;
import org.elasticsearch.xpack.spatial.search.runtime.GeoShapeScriptFieldExistsQuery;
import org.elasticsearch.xpack.spatial.search.runtime.GeoShapeScriptFieldGeoShapeQuery;

public final class GeoShapeScriptFieldType
extends AbstractScriptFieldType<GeometryFieldScript.LeafFactory>
implements GeoShapeQueryable {
    private final GeoFormatterFactory<Geometry> geoFormatterFactory;

    public static RuntimeField.Parser typeParser(final GeoFormatterFactory<Geometry> geoFormatterFactory) {
        return new RuntimeField.Parser(name -> new AbstractScriptFieldType.Builder<GeometryFieldScript.Factory>(name, GeometryFieldScript.CONTEXT){

            @Override
            protected AbstractScriptFieldType<?> createFieldType(String name, GeometryFieldScript.Factory factory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
                return new GeoShapeScriptFieldType(name, factory, this.getScript(), this.meta(), onScriptError, geoFormatterFactory);
            }

            @Override
            protected GeometryFieldScript.Factory getParseFromSourceFactory() {
                return GeometryFieldScript.PARSE_FROM_SOURCE;
            }

            @Override
            protected GeometryFieldScript.Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
                return GeometryFieldScript.leafAdapter(parentScriptFactory);
            }
        });
    }

    GeoShapeScriptFieldType(String name, GeometryFieldScript.Factory scriptFactory, Script script, Map<String, String> meta, OnScriptError onScriptError, GeoFormatterFactory<Geometry> geoFormatterFactory) {
        super(name, searchLookup -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup, onScriptError), script, scriptFactory.isResultDeterministic(), meta);
        this.geoFormatterFactory = geoFormatterFactory;
    }

    @Override
    public String typeName() {
        return "geo_shape";
    }

    @Override
    protected Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        throw new IllegalArgumentException("Runtime field [" + this.name() + "] of type [" + this.typeName() + "] does not support range queries");
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        throw new IllegalArgumentException("Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]");
    }

    @Override
    public GeoShapeScriptFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        return new GeoShapeScriptFieldData.Builder(this.name(), (GeometryFieldScript.LeafFactory)this.leafFactory(fieldDataContext.lookupSupplier().get()), GeoShapeWithDocValuesFieldMapper.GeoShapeDocValuesField::new);
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new GeoShapeScriptFieldExistsQuery(this.script, (GeometryFieldScript.LeafFactory)this.leafFactory(context), this.name());
    }

    @Override
    public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
        return new GeoShapeScriptFieldGeoShapeQuery(this.script, (GeometryFieldScript.LeafFactory)this.leafFactory(context), fieldName, relation, geometries);
    }

    @Override
    public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        final GeometryFieldScript.LeafFactory leafFactory = (GeometryFieldScript.LeafFactory)this.leafFactory(context.lookup());
        final Function<List<Geometry>, List<Object>> formatter = this.geoFormatterFactory.getFormatter(format != null ? format : "geojson", Function.identity());
        return new ValueFetcher(){
            private GeometryFieldScript script;

            @Override
            public void setNextReader(LeafReaderContext context) {
                this.script = leafFactory.newInstance(context);
            }

            @Override
            public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
                this.script.runForDoc(doc);
                if (this.script.count() == 0) {
                    return List.of();
                }
                return (List)formatter.apply(List.of(this.script.geometry()));
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NEEDS_SOURCE;
            }
        };
    }
}

