/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RevertModelSnapshotAction
extends ActionType<Response> {
    public static final RevertModelSnapshotAction INSTANCE = new RevertModelSnapshotAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/model_snapshots/revert";

    private RevertModelSnapshotAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private static final ParseField MODEL = new ParseField("model", new String[0]);
        private final ModelSnapshot model;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.model = new ModelSnapshot(in);
        }

        public Response(ModelSnapshot modelSnapshot) {
            this.model = modelSnapshot;
        }

        public ModelSnapshot getModel() {
            return this.model;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.model.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MODEL.getPreferredName());
            builder = this.model.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.model);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.model, other.model);
        }

        public final String toString() {
            return Strings.toString(this);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
        public static final ParseField DELETE_INTERVENING = new ParseField("delete_intervening_results", new String[0]);
        private static final ParseField FORCE = new ParseField("force", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/model_snapshots/revert", Request::new);
        private String jobId;
        private String snapshotId;
        private boolean deleteInterveningResults;
        private boolean force;

        public static Request parseRequest(String jobId, String snapshotId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (jobId != null) {
                request.jobId = jobId;
            }
            if (snapshotId != null) {
                request.snapshotId = snapshotId;
            }
            return request;
        }

        public Request() {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
            this.deleteInterveningResults = in.readBoolean();
            this.force = in.readBoolean();
        }

        public Request(String jobId, String snapshotId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, SNAPSHOT_ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public boolean getDeleteInterveningResults() {
            return this.deleteInterveningResults;
        }

        public void setDeleteInterveningResults(boolean deleteInterveningResults) {
            this.deleteInterveningResults = deleteInterveningResults;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
            out.writeBoolean(this.deleteInterveningResults);
            out.writeBoolean(this.force);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
            builder.field(DELETE_INTERVENING.getPreferredName(), this.deleteInterveningResults);
            builder.field(FORCE.getPreferredName(), this.force);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.snapshotId, this.deleteInterveningResults, this.force);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.deleteInterveningResults, other.deleteInterveningResults) && this.force == other.force;
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString((request, snapshotId) -> {
                request.snapshotId = snapshotId;
            }, SNAPSHOT_ID);
            PARSER.declareBoolean(Request::setDeleteInterveningResults, DELETE_INTERVENING);
            PARSER.declareBoolean(Request::setForce, FORCE);
        }
    }
}

