/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.fieldvisitor.FieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

final class TranslogDirectoryReader
extends DirectoryReader {
    private final LeafReader leafReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryReader create(ShardId shardId, Translog.Index operation, MappingLookup mappingLookup, DocumentParser documentParser, EngineConfig engineConfig, Runnable onSegmentCreated, boolean forceSynthetic) throws IOException {
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        boolean success = false;
        try {
            LeafReader leafReader;
            if (mappingLookup.isSourceSynthetic() || forceSynthetic) {
                onSegmentCreated.run();
                leafReader = TranslogDirectoryReader.createInMemoryReader(shardId, engineConfig, directory, documentParser, mappingLookup, false, operation);
            } else {
                leafReader = new TranslogLeafReader(shardId, operation, mappingLookup, documentParser, engineConfig, directory, onSegmentCreated);
            }
            ElasticsearchDirectoryReader directoryReader = ElasticsearchDirectoryReader.wrap(new TranslogDirectoryReader(directory, leafReader), shardId);
            success = true;
            ElasticsearchDirectoryReader elasticsearchDirectoryReader = directoryReader;
            return elasticsearchDirectoryReader;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)directory);
            }
        }
    }

    private TranslogDirectoryReader(Directory directory, LeafReader leafReader) throws IOException {
        super(directory, new LeafReader[]{leafReader}, null);
        this.leafReader = leafReader;
    }

    private static UnsupportedOperationException unsupported() {
        assert (false) : "unsupported operation";
        return new UnsupportedOperationException();
    }

    @Override
    protected DirectoryReader doOpenIfChanged() {
        throw TranslogDirectoryReader.unsupported();
    }

    @Override
    protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
        throw TranslogDirectoryReader.unsupported();
    }

    @Override
    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
        throw TranslogDirectoryReader.unsupported();
    }

    @Override
    public long getVersion() {
        throw TranslogDirectoryReader.unsupported();
    }

    @Override
    public boolean isCurrent() {
        throw TranslogDirectoryReader.unsupported();
    }

    @Override
    public IndexCommit getIndexCommit() {
        throw TranslogDirectoryReader.unsupported();
    }

    @Override
    protected void doClose() throws IOException {
        this.leafReader.close();
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.leafReader.getReaderCacheHelper();
    }

    private static LeafReader createInMemoryReader(ShardId shardId, EngineConfig engineConfig, final Directory directory, DocumentParser documentParser, MappingLookup mappingLookup, boolean rootDocOnly, Translog.Index operation) {
        SequentialStoredFieldsLeafReader sequentialStoredFieldsLeafReader;
        ParsedDocument parsedDocs = documentParser.parseDocument(new SourceToParse(operation.id(), operation.source(), XContentHelper.xContentType(operation.source()), operation.routing()), mappingLookup);
        parsedDocs.updateSeqID(operation.seqNo(), operation.primaryTerm());
        parsedDocs.version().setLongValue(operation.version());
        IndexWriterConfig writeConfig = new IndexWriterConfig(engineConfig.getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE).setCodec(engineConfig.getCodec());
        IndexWriter writer = new IndexWriter(directory, writeConfig);
        try {
            int numDocs;
            if (rootDocOnly) {
                numDocs = 1;
                writer.addDocument(parsedDocs.rootDoc());
            } else {
                numDocs = parsedDocs.docs().size();
                writer.addDocuments(parsedDocs.docs());
            }
            DirectoryReader reader = TranslogDirectoryReader.open(writer);
            if (reader.leaves().size() != 1 || reader.leaves().get(0).reader().numDocs() != numDocs) {
                reader.close();
                throw new IllegalStateException("Expected a single segment with " + numDocs + " documents, but [" + reader.leaves().size() + " segments with " + reader.leaves().get(0).reader().numDocs() + " documents");
            }
            final LeafReader leafReader = reader.leaves().get(0).reader();
            sequentialStoredFieldsLeafReader = new SequentialStoredFieldsLeafReader(leafReader){

                @Override
                protected void doClose() throws IOException {
                    IOUtils.close(() -> super.doClose(), directory);
                }

                @Override
                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return leafReader.getCoreCacheHelper();
                }

                @Override
                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return leafReader.getReaderCacheHelper();
                }

                @Override
                public StoredFieldsReader getSequentialStoredFieldsReader() {
                    return Lucene.segmentReader(leafReader).getFieldsReader().getMergeInstance();
                }

                @Override
                protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
                    return reader;
                }
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new EngineException(shardId, "failed to create an in-memory segment for get [" + operation.id() + "]", e, new Object[0]);
            }
        }
        writer.close();
        return sequentialStoredFieldsLeafReader;
    }

    private static class TranslogLeafReader
    extends LeafReader {
        private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
        private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo("_routing", 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
        private static final FieldInfo FAKE_ID_FIELD = new FieldInfo("_id", 3, false, false, false, IndexOptions.DOCS, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
        private static final Set<String> TRANSLOG_FIELD_NAMES = Set.of("_source", "_routing", "_id");
        private final ShardId shardId;
        private final Translog.Index operation;
        private final MappingLookup mappingLookup;
        private final DocumentParser documentParser;
        private final EngineConfig engineConfig;
        private final Directory directory;
        private final Runnable onSegmentCreated;
        private final AtomicReference<LeafReader> delegate = new AtomicReference();
        private final BytesRef uid;

        TranslogLeafReader(ShardId shardId, Translog.Index operation, MappingLookup mappingLookup, DocumentParser documentParser, EngineConfig engineConfig, Directory directory, Runnable onSegmentCreated) {
            this.shardId = shardId;
            this.operation = operation;
            this.mappingLookup = mappingLookup;
            this.documentParser = documentParser;
            this.engineConfig = engineConfig;
            this.onSegmentCreated = onSegmentCreated;
            this.directory = directory;
            this.uid = Uid.encodeId(operation.id());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeafReader getDelegate() {
            this.ensureOpen();
            LeafReader reader = this.delegate.get();
            if (reader == null) {
                TranslogLeafReader translogLeafReader = this;
                synchronized (translogLeafReader) {
                    this.ensureOpen();
                    reader = this.delegate.get();
                    if (reader == null) {
                        LeafReader indexReader = TranslogDirectoryReader.createInMemoryReader(this.shardId, this.engineConfig, this.directory, this.documentParser, this.mappingLookup, true, this.operation);
                        reader = indexReader.leaves().get(0).reader();
                        LeafReader existing = this.delegate.getAndSet(reader);
                        assert (existing == null);
                        this.onSegmentCreated.run();
                    }
                }
            }
            return reader;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.getDelegate().getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        @Override
        public Terms terms(String field) throws IOException {
            if (this.delegate.get() == null && field.equals("_id")) {
                return new FakeTerms(this.uid);
            }
            return this.getDelegate().terms(field);
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            if (this.delegate.get() == null) {
                if (field.equals("_version")) {
                    return new FakeNumericDocValues(this.operation.version());
                }
                if (field.equals("_seq_no")) {
                    return new FakeNumericDocValues(this.operation.seqNo());
                }
                if (field.equals("_primary_term")) {
                    return new FakeNumericDocValues(this.operation.primaryTerm());
                }
            }
            return this.getDelegate().getNumericDocValues(field);
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return this.getDelegate().getBinaryDocValues(field);
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return this.getDelegate().getSortedDocValues(field);
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            return this.getDelegate().getSortedNumericDocValues(field);
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            return this.getDelegate().getSortedSetDocValues(field);
        }

        @Override
        public NumericDocValues getNormValues(String field) throws IOException {
            return this.getDelegate().getNormValues(field);
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.getDelegate().getFloatVectorValues(field);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.getDelegate().getByteVectorValues(field);
        }

        @Override
        public void searchNearestVectors(String field, float[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            this.getDelegate().searchNearestVectors(field, target, collector, acceptDocs);
        }

        @Override
        public void searchNearestVectors(String field, byte[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            this.getDelegate().searchNearestVectors(field, target, collector, acceptDocs);
        }

        @Override
        public FieldInfos getFieldInfos() {
            return this.getDelegate().getFieldInfos();
        }

        @Override
        public Bits getLiveDocs() {
            return null;
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            return this.getDelegate().getPointValues(field);
        }

        @Override
        public void checkIntegrity() throws IOException {
        }

        @Override
        public LeafMetaData getMetaData() {
            return this.getDelegate().getMetaData();
        }

        @Override
        public Fields getTermVectors(int docID) throws IOException {
            return this.getDelegate().getTermVectors(docID);
        }

        @Override
        public TermVectors termVectors() throws IOException {
            return this.getDelegate().termVectors();
        }

        @Override
        public StoredFields storedFields() throws IOException {
            return new StoredFields(){

                @Override
                public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                    assert (docID == 0);
                    if (delegate.get() == null && visitor instanceof FieldNamesProvidingStoredFieldsVisitor && TRANSLOG_FIELD_NAMES.containsAll(((FieldNamesProvidingStoredFieldsVisitor)visitor).getFieldNames())) {
                        this.readStoredFieldsDirectly(visitor);
                        return;
                    }
                    this.getDelegate().storedFields().document(docID, visitor);
                }
            };
        }

        @Override
        public int numDocs() {
            return 1;
        }

        @Override
        public int maxDoc() {
            return 1;
        }

        @Override
        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            this.storedFields().document(docID, visitor);
        }

        private void readStoredFieldsDirectly(StoredFieldVisitor visitor) throws IOException {
            if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
                BytesReference sourceBytes = this.operation.source();
                assert (BytesReference.toBytes(sourceBytes) == sourceBytes.toBytesRef().bytes);
                SourceFieldMapper mapper = this.mappingLookup.getMapping().getMetadataMapperByClass(SourceFieldMapper.class);
                if (mapper != null) {
                    try {
                        sourceBytes = mapper.applyFilters(this.mappingLookup, sourceBytes, null, true);
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to reapply filters after reading from translog", e);
                    }
                }
                if (sourceBytes != null) {
                    visitor.binaryField(FAKE_SOURCE_FIELD, BytesReference.toBytes(sourceBytes));
                }
            }
            if (this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
                visitor.stringField(FAKE_ROUTING_FIELD, this.operation.routing());
            }
            if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
                byte[] id = new byte[this.uid.length];
                System.arraycopy(this.uid.bytes, this.uid.offset, id, 0, this.uid.length);
                visitor.binaryField(FAKE_ID_FIELD, id);
            }
        }

        @Override
        protected synchronized void doClose() throws IOException {
            LeafReader leaf = this.delegate.get();
            if (leaf != null) {
                leaf.close();
            } else {
                this.directory.close();
            }
        }
    }

    private static class FakeNumericDocValues
    extends NumericDocValues {
        private final long value;
        private final DocIdSetIterator disi = DocIdSetIterator.all(1);

        FakeNumericDocValues(long value) {
            this.value = value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advance(target) == target;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }

    private static class FakePostingsEnum
    extends PostingsEnum {
        private final BytesRef term;
        private int iter = -1;

        private FakePostingsEnum(BytesRef term) {
            this.term = term;
        }

        @Override
        public int freq() {
            return 1;
        }

        @Override
        public int nextPosition() {
            return 0;
        }

        @Override
        public int startOffset() {
            return 0;
        }

        @Override
        public int endOffset() {
            return this.term.length;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public int docID() {
            return this.iter > 0 ? Integer.MAX_VALUE : this.iter;
        }

        @Override
        public int nextDoc() {
            return ++this.iter == 0 ? 0 : Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        @Override
        public long cost() {
            return 0L;
        }
    }

    private static class FakeTermsEnum
    extends BaseTermsEnum {
        private final BytesRef term;
        private long position = -1L;

        FakeTermsEnum(BytesRef term) {
            this.term = term;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            int cmp = text.compareTo(this.term);
            if (cmp == 0) {
                this.position = 0L;
                return TermsEnum.SeekStatus.FOUND;
            }
            if (cmp < 0) {
                this.position = 0L;
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            this.position = Long.MAX_VALUE;
            return TermsEnum.SeekStatus.END;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.position = ord;
        }

        @Override
        public BytesRef term() throws IOException {
            assert (this.position == 0L);
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.position;
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return 1L;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return new FakePostingsEnum(this.term);
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            throw TranslogDirectoryReader.unsupported();
        }

        @Override
        public BytesRef next() throws IOException {
            return ++this.position == 0L ? this.term : null;
        }
    }

    private static class FakeTerms
    extends Terms {
        private final BytesRef uid;

        FakeTerms(BytesRef uid) {
            this.uid = uid;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new FakeTermsEnum(this.uid);
        }

        @Override
        public long size() throws IOException {
            return 1L;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return 1L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return 1L;
        }

        @Override
        public int getDocCount() throws IOException {
            return 1;
        }

        @Override
        public boolean hasFreqs() {
            return false;
        }

        @Override
        public boolean hasOffsets() {
            return false;
        }

        @Override
        public boolean hasPositions() {
            return false;
        }

        @Override
        public boolean hasPayloads() {
            return false;
        }
    }
}

