/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class AllocationActionListener<T> {
    private final ActionListener<T> delegate;
    private final SetOnce<T> response = new SetOnce();
    private final AtomicInteger listenersExecuted = new AtomicInteger(2);
    private final ThreadContext context;
    private final Supplier<ThreadContext.StoredContext> original;
    private final SetOnce<Map<String, List<String>>> additionalResponseHeaders = new SetOnce();

    public static ActionListener<Void> rerouteCompletionIsNotRequired() {
        return ActionListener.noop();
    }

    public AllocationActionListener(ActionListener<T> delegate, ThreadContext context) {
        this.delegate = delegate;
        this.context = context;
        this.original = context.newRestorableContext(false);
    }

    private void notifyListenerExecuted() {
        if (this.listenersExecuted.decrementAndGet() == 0) {
            this.executeInContext(() -> this.delegate.onResponse(this.response.get()));
        }
    }

    private void notifyListenerFailed(Exception e) {
        this.executeInContext(() -> this.delegate.onFailure(e));
    }

    private void executeInContext(Runnable action) {
        try (ThreadContext.StoredContext ignore2 = this.original.get();){
            AllocationActionListener.appendAdditionalResponseHeaders(this.context, this.additionalResponseHeaders.get());
            action.run();
        }
    }

    private static void appendAdditionalResponseHeaders(ThreadContext context, Map<String, List<String>> additionalHeaders) {
        if (additionalHeaders != null) {
            for (Map.Entry<String, List<String>> entry : additionalHeaders.entrySet()) {
                for (String header : entry.getValue()) {
                    context.addResponseHeader(entry.getKey(), header);
                }
            }
        }
    }

    public ActionListener<T> clusterStateUpdate() {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T response) {
                AllocationActionListener.this.response.set(response);
                AllocationActionListener.this.additionalResponseHeaders.set(AllocationActionListener.this.context.getResponseHeaders());
                AllocationActionListener.this.notifyListenerExecuted();
            }

            @Override
            public void onFailure(Exception e) {
                AllocationActionListener.this.additionalResponseHeaders.set(AllocationActionListener.this.context.getResponseHeaders());
                AllocationActionListener.this.notifyListenerFailed(e);
            }
        };
    }

    public ActionListener<Void> reroute() {
        return new ActionListener<Void>(){

            @Override
            public void onResponse(Void unused) {
                AllocationActionListener.this.notifyListenerExecuted();
            }

            @Override
            public void onFailure(Exception e) {
                AllocationActionListener.this.notifyListenerFailed(e);
            }
        };
    }
}

