/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.sql.TranslateResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TranslateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Integer fetchSize;
    @Nullable
    private final Query filter;
    private final String query;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<TranslateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslateRequest::setupTranslateRequestDeserializer);
    public static final Endpoint<TranslateRequest, TranslateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TranslateRequest, TranslateResponse>("es/sql.translate", request -> "POST", request -> "/_sql/translate", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, TranslateResponse._DESERIALIZER);

    private TranslateRequest(Builder builder) {
        this.fetchSize = builder.fetchSize;
        this.filter = builder.filter;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.timeZone = builder.timeZone;
    }

    public static TranslateRequest of(Function<Builder, ObjectBuilder<TranslateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer fetchSize() {
        return this.fetchSize;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fetchSize != null) {
            generator.writeKey("fetch_size");
            generator.write(this.fetchSize);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    protected static void setupTranslateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fetchSize, JsonpDeserializer.integerDeserializer(), "fetch_size");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TranslateRequest> {
        @Nullable
        private Integer fetchSize;
        @Nullable
        private Query filter;
        private String query;
        @Nullable
        private String timeZone;

        public final Builder fetchSize(@Nullable Integer value) {
            this.fetchSize = value;
            return this;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder filter(QueryVariant value) {
            this.filter = value._toQuery();
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TranslateRequest build() {
            this._checkSingleUse();
            return new TranslateRequest(this);
        }
    }
}

