/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.IndexSettingsLifecycleStep;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexSettingsLifecycle
implements JsonpSerializable {
    @Nullable
    private final String name;
    @Nullable
    private final Boolean indexingComplete;
    @Nullable
    private final Long originationDate;
    @Nullable
    private final Boolean parseOriginationDate;
    @Nullable
    private final IndexSettingsLifecycleStep step;
    @Nullable
    private final String rolloverAlias;
    @Nullable
    private final Boolean preferIlm;
    public static final JsonpDeserializer<IndexSettingsLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsLifecycle::setupIndexSettingsLifecycleDeserializer);

    private IndexSettingsLifecycle(Builder builder) {
        this.name = builder.name;
        this.indexingComplete = builder.indexingComplete;
        this.originationDate = builder.originationDate;
        this.parseOriginationDate = builder.parseOriginationDate;
        this.step = builder.step;
        this.rolloverAlias = builder.rolloverAlias;
        this.preferIlm = builder.preferIlm;
    }

    public static IndexSettingsLifecycle of(Function<Builder, ObjectBuilder<IndexSettingsLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Boolean indexingComplete() {
        return this.indexingComplete;
    }

    @Nullable
    public final Long originationDate() {
        return this.originationDate;
    }

    @Nullable
    public final Boolean parseOriginationDate() {
        return this.parseOriginationDate;
    }

    @Nullable
    public final IndexSettingsLifecycleStep step() {
        return this.step;
    }

    @Nullable
    public final String rolloverAlias() {
        return this.rolloverAlias;
    }

    @Nullable
    public final Boolean preferIlm() {
        return this.preferIlm;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.indexingComplete != null) {
            generator.writeKey("indexing_complete");
            generator.write(this.indexingComplete);
        }
        if (this.originationDate != null) {
            generator.writeKey("origination_date");
            generator.write(this.originationDate);
        }
        if (this.parseOriginationDate != null) {
            generator.writeKey("parse_origination_date");
            generator.write(this.parseOriginationDate);
        }
        if (this.step != null) {
            generator.writeKey("step");
            this.step.serialize(generator, mapper);
        }
        if (this.rolloverAlias != null) {
            generator.writeKey("rollover_alias");
            generator.write(this.rolloverAlias);
        }
        if (this.preferIlm != null) {
            generator.writeKey("prefer_ilm");
            generator.write(this.preferIlm);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexSettingsLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::indexingComplete, JsonpDeserializer.booleanDeserializer(), "indexing_complete");
        op.add(Builder::originationDate, JsonpDeserializer.longDeserializer(), "origination_date");
        op.add(Builder::parseOriginationDate, JsonpDeserializer.booleanDeserializer(), "parse_origination_date");
        op.add(Builder::step, IndexSettingsLifecycleStep._DESERIALIZER, "step");
        op.add(Builder::rolloverAlias, JsonpDeserializer.stringDeserializer(), "rollover_alias");
        op.add(Builder::preferIlm, JsonpDeserializer.booleanDeserializer(), "prefer_ilm");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexSettingsLifecycle> {
        @Nullable
        private String name;
        @Nullable
        private Boolean indexingComplete;
        @Nullable
        private Long originationDate;
        @Nullable
        private Boolean parseOriginationDate;
        @Nullable
        private IndexSettingsLifecycleStep step;
        @Nullable
        private String rolloverAlias;
        @Nullable
        private Boolean preferIlm;

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder indexingComplete(@Nullable Boolean value) {
            this.indexingComplete = value;
            return this;
        }

        public final Builder originationDate(@Nullable Long value) {
            this.originationDate = value;
            return this;
        }

        public final Builder parseOriginationDate(@Nullable Boolean value) {
            this.parseOriginationDate = value;
            return this;
        }

        public final Builder step(@Nullable IndexSettingsLifecycleStep value) {
            this.step = value;
            return this;
        }

        public final Builder step(Function<IndexSettingsLifecycleStep.Builder, ObjectBuilder<IndexSettingsLifecycleStep>> fn) {
            return this.step(fn.apply(new IndexSettingsLifecycleStep.Builder()).build());
        }

        public final Builder rolloverAlias(@Nullable String value) {
            this.rolloverAlias = value;
            return this;
        }

        public final Builder preferIlm(@Nullable Boolean value) {
            this.preferIlm = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexSettingsLifecycle build() {
            this._checkSingleUse();
            return new IndexSettingsLifecycle(this);
        }
    }
}

