/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.ConnectionClosedException;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.mocksocket.MockHttpServer;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.NeverMatcher;
import org.elasticsearch.test.fixture.HttpHeaderParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;

@SuppressForbidden(reason="use a http server")
public abstract class AbstractBlobContainerRetriesTestCase
extends ESTestCase {
    private static final long MAX_RANGE_VAL = 0x7FFFFFFFFFFFFFFEL;
    protected HttpServer httpServer;

    @Before
    public void setUp() throws Exception {
        this.httpServer = MockHttpServer.createHttp((InetSocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), (int)0);
        this.httpServer.start();
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.httpServer.stop(0);
        super.tearDown();
    }

    protected abstract String downloadStorageEndpoint(BlobContainer var1, String var2);

    protected abstract String bytesContentType();

    protected abstract Class<? extends Exception> unresponsiveExceptionType();

    protected Matcher<Object> readTimeoutExceptionMatcher() {
        return Matchers.either((Matcher)Matchers.instanceOf(SocketTimeoutException.class)).or(Matchers.instanceOf(ConnectionClosedException.class)).or(Matchers.instanceOf(RuntimeException.class));
    }

    public void testReadNonexistentBlobThrowsNoSuchFileException() {
        BlobContainer blobContainer = this.blobContainerBuilder().maxRetries(AbstractBlobContainerRetriesTestCase.between(1, 5)).build();
        long position = AbstractBlobContainerRetriesTestCase.randomLongBetween(0L, 0x7FFFFFFFFFFFFFFEL);
        int length = AbstractBlobContainerRetriesTestCase.randomIntBetween(1, Math.toIntExact(Math.min(Integer.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL - position)));
        Exception exception = (Exception)AbstractBlobContainerRetriesTestCase.expectThrows(NoSuchFileException.class, () -> {
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                Streams.readFully((InputStream)blobContainer.readBlob(BlobStoreTestUtil.randomPurpose(), "read_nonexistent_blob"));
            } else {
                Streams.readFully((InputStream)blobContainer.readBlob(BlobStoreTestUtil.randomPurpose(), "read_nonexistent_blob", 0L, 1L));
            }
        });
        String fullBlobPath = blobContainer.path().buildAsString() + "read_nonexistent_blob";
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getMessage().toLowerCase(Locale.ROOT), Matchers.containsString((String)("blob object [" + fullBlobPath + "] not found")));
        AbstractBlobContainerRetriesTestCase.assertThat(((NoSuchFileException)AbstractBlobContainerRetriesTestCase.expectThrows(NoSuchFileException.class, () -> Streams.readFully((InputStream)blobContainer.readBlob(BlobStoreTestUtil.randomPurpose(), "read_nonexistent_blob", position, (long)length)))).getMessage().toLowerCase(Locale.ROOT), Matchers.containsString((String)("blob object [" + fullBlobPath + "] not found")));
    }

    public void testReadBlobWithRetries() throws Exception {
        int maxRetries = AbstractBlobContainerRetriesTestCase.randomInt(5);
        CountDown countDown = new CountDown(maxRetries + 1);
        byte[] bytes = AbstractBlobContainerRetriesTestCase.randomBlobContent();
        TimeValue readTimeout = TimeValue.timeValueSeconds((long)AbstractBlobContainerRetriesTestCase.between(1, 3));
        BlobContainer blobContainer = this.blobContainerBuilder().maxRetries(maxRetries).readTimeout(readTimeout).build();
        this.httpServer.createContext(this.downloadStorageEndpoint(blobContainer, "read_blob_max_retries"), exchange -> {
            Streams.readFully((InputStream)exchange.getRequestBody());
            if (countDown.countDown()) {
                int rangeStart = AbstractBlobContainerRetriesTestCase.getRangeStart(exchange);
                AbstractBlobContainerRetriesTestCase.assertThat(rangeStart, Matchers.lessThan((Comparable)Integer.valueOf(bytes.length)));
                exchange.getResponseHeaders().add("Content-Type", this.bytesContentType());
                exchange.sendResponseHeaders(200, bytes.length - rangeStart);
                exchange.getResponseBody().write(bytes, rangeStart, bytes.length - rangeStart);
                exchange.close();
                return;
            }
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                exchange.sendResponseHeaders(AbstractBlobContainerRetriesTestCase.randomFrom(500, 502, 503, 504), -1L);
            } else if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                this.sendIncompleteContent(exchange, bytes);
            }
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                exchange.close();
            }
        });
        try (InputStream inputStream = blobContainer.readBlob(this.randomRetryingPurpose(), "read_blob_max_retries");){
            InputStream wrappedStream;
            int readLimit;
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                readLimit = AbstractBlobContainerRetriesTestCase.randomIntBetween(0, bytes.length);
                wrappedStream = Streams.limitStream((InputStream)inputStream, (long)readLimit);
            } else {
                readLimit = bytes.length;
                wrappedStream = inputStream;
            }
            byte[] bytesRead = BytesReference.toBytes((BytesReference)Streams.readFully((InputStream)wrappedStream));
            this.logger.info("maxRetries={}, readLimit={}, byteSize={}, bytesRead={}", (Object)maxRetries, (Object)readLimit, (Object)bytes.length, (Object)bytesRead.length);
            AbstractBlobContainerRetriesTestCase.assertArrayEquals((byte[])Arrays.copyOfRange(bytes, 0, readLimit), (byte[])bytesRead);
            if (readLimit < bytes.length) {
            } else {
                AbstractBlobContainerRetriesTestCase.assertTrue((boolean)countDown.isCountedDown());
            }
        }
    }

    public void testReadRangeBlobWithRetries() throws Exception {
        int maxRetries = AbstractBlobContainerRetriesTestCase.rarely() ? AbstractBlobContainerRetriesTestCase.randomInt(5) : 1;
        CountDown countDown = new CountDown(maxRetries + 1);
        TimeValue readTimeout = TimeValue.timeValueSeconds((long)AbstractBlobContainerRetriesTestCase.between(5, 10));
        BlobContainer blobContainer = this.blobContainerBuilder().maxRetries(maxRetries).readTimeout(readTimeout).build();
        byte[] bytes = AbstractBlobContainerRetriesTestCase.randomBlobContent();
        this.httpServer.createContext(this.downloadStorageEndpoint(blobContainer, "read_range_blob_max_retries"), exchange -> {
            Streams.readFully((InputStream)exchange.getRequestBody());
            if (countDown.countDown()) {
                int rangeStart = AbstractBlobContainerRetriesTestCase.getRangeStart(exchange);
                AbstractBlobContainerRetriesTestCase.assertThat(rangeStart, Matchers.lessThan((Comparable)Integer.valueOf(bytes.length)));
                AbstractBlobContainerRetriesTestCase.assertTrue((boolean)AbstractBlobContainerRetriesTestCase.getRangeEnd(exchange).isPresent());
                int rangeEnd = AbstractBlobContainerRetriesTestCase.getRangeEnd(exchange).getAsInt();
                AbstractBlobContainerRetriesTestCase.assertThat(rangeEnd, Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(rangeStart)));
                int effectiveRangeEnd = Math.min(bytes.length - 1, rangeEnd);
                int length = effectiveRangeEnd - rangeStart + 1;
                exchange.getResponseHeaders().add("Content-Type", this.bytesContentType());
                exchange.sendResponseHeaders(200, length);
                exchange.getResponseBody().write(bytes, rangeStart, length);
                exchange.close();
                return;
            }
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                exchange.sendResponseHeaders(AbstractBlobContainerRetriesTestCase.randomFrom(500, 502, 503, 504), -1L);
            } else if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                this.sendIncompleteContent(exchange, bytes);
            }
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                exchange.close();
            }
        });
        int position = AbstractBlobContainerRetriesTestCase.randomIntBetween(0, bytes.length - 1);
        int length = AbstractBlobContainerRetriesTestCase.randomIntBetween(0, AbstractBlobContainerRetriesTestCase.randomBoolean() ? bytes.length : Integer.MAX_VALUE);
        try (InputStream inputStream = blobContainer.readBlob(this.randomRetryingPurpose(), "read_range_blob_max_retries", (long)position, (long)length);){
            InputStream wrappedStream;
            int readLimit;
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                readLimit = AbstractBlobContainerRetriesTestCase.randomIntBetween(0, length);
                wrappedStream = Streams.limitStream((InputStream)inputStream, (long)readLimit);
            } else {
                readLimit = length;
                wrappedStream = inputStream;
            }
            byte[] bytesRead = BytesReference.toBytes((BytesReference)Streams.readFully((InputStream)wrappedStream));
            this.logger.info("maxRetries={}, position={}, length={}, readLimit={}, byteSize={}, bytesRead={}", (Object)maxRetries, (Object)position, (Object)length, (Object)readLimit, (Object)bytes.length, (Object)bytesRead.length);
            AbstractBlobContainerRetriesTestCase.assertArrayEquals((byte[])Arrays.copyOfRange(bytes, position, Math.min(bytes.length, position + readLimit)), (byte[])bytesRead);
            if (readLimit != 0) {
                if (readLimit < length && readLimit == bytesRead.length) {
                } else {
                    AbstractBlobContainerRetriesTestCase.assertTrue((boolean)countDown.isCountedDown());
                }
            }
        }
    }

    public void testReadBlobWithReadTimeouts() {
        int maxRetries = AbstractBlobContainerRetriesTestCase.randomInt(5);
        TimeValue readTimeout = TimeValue.timeValueMillis((long)AbstractBlobContainerRetriesTestCase.between(100, 200));
        BlobContainer blobContainer = this.blobContainerBuilder().maxRetries(maxRetries).readTimeout(readTimeout).build();
        this.httpServer.createContext(this.downloadStorageEndpoint(blobContainer, "read_blob_unresponsive"), exchange -> {});
        Exception exception = (Exception)AbstractBlobContainerRetriesTestCase.expectThrows(this.unresponsiveExceptionType(), () -> Streams.readFully((InputStream)blobContainer.readBlob(this.randomFiniteRetryingPurpose(), "read_blob_unresponsive")));
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getMessage().toLowerCase(Locale.ROOT), Matchers.containsString((String)"read timed out"));
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getCause(), Matchers.instanceOf(SocketTimeoutException.class));
        byte[] bytes = AbstractBlobContainerRetriesTestCase.randomBlobContent();
        this.httpServer.createContext(this.downloadStorageEndpoint(blobContainer, "read_blob_incomplete"), exchange -> this.sendIncompleteContent(exchange, bytes));
        int position = AbstractBlobContainerRetriesTestCase.randomIntBetween(0, bytes.length - 1);
        int length = AbstractBlobContainerRetriesTestCase.randomIntBetween(1, AbstractBlobContainerRetriesTestCase.randomBoolean() ? bytes.length : Integer.MAX_VALUE);
        exception = (Exception)AbstractBlobContainerRetriesTestCase.expectThrows(Exception.class, () -> {
            try (InputStream stream = AbstractBlobContainerRetriesTestCase.randomBoolean() ? blobContainer.readBlob(this.randomFiniteRetryingPurpose(), "read_blob_incomplete") : blobContainer.readBlob(this.randomFiniteRetryingPurpose(), "read_blob_incomplete", (long)position, (long)length);){
                Streams.readFully((InputStream)stream);
            }
        });
        AbstractBlobContainerRetriesTestCase.assertThat(exception, this.readTimeoutExceptionMatcher());
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getMessage().toLowerCase(Locale.ROOT), Matchers.anyOf((Matcher)Matchers.containsString((String)"read timed out"), (Matcher)Matchers.containsString((String)"premature end of chunk coded message body: closing chunk expected"), (Matcher)Matchers.containsString((String)"Read timed out"), (Matcher)Matchers.containsString((String)"unexpected end of file from server")));
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getSuppressed().length, this.getMaxRetriesMatcher(maxRetries));
    }

    protected Matcher<Integer> getMaxRetriesMatcher(int maxRetries) {
        return Matchers.equalTo((Object)maxRetries);
    }

    protected OperationPurpose randomRetryingPurpose() {
        return BlobStoreTestUtil.randomPurpose();
    }

    protected OperationPurpose randomFiniteRetryingPurpose() {
        return BlobStoreTestUtil.randomPurpose();
    }

    public void testReadBlobWithNoHttpResponse() {
        TimeValue readTimeout = TimeValue.timeValueMillis((long)AbstractBlobContainerRetriesTestCase.between(100, 200));
        BlobContainer blobContainer = this.blobContainerBuilder().maxRetries(AbstractBlobContainerRetriesTestCase.randomInt(5)).readTimeout(readTimeout).build();
        this.httpServer.createContext(this.downloadStorageEndpoint(blobContainer, "read_blob_no_response"), HttpExchange::close);
        Exception exception = (Exception)AbstractBlobContainerRetriesTestCase.expectThrows(this.unresponsiveExceptionType(), () -> {
            if (AbstractBlobContainerRetriesTestCase.randomBoolean()) {
                Streams.readFully((InputStream)blobContainer.readBlob(this.randomFiniteRetryingPurpose(), "read_blob_no_response"));
            } else {
                Streams.readFully((InputStream)blobContainer.readBlob(this.randomFiniteRetryingPurpose(), "read_blob_no_response", 0L, 1L));
            }
        });
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getMessage().toLowerCase(Locale.ROOT), Matchers.either((Matcher)Matchers.containsString((String)"the target server failed to respond")).or(Matchers.containsString((String)"unexpected end of file from server")));
    }

    public void testReadBlobWithPrematureConnectionClose() {
        int maxRetries = AbstractBlobContainerRetriesTestCase.randomInt(20);
        BlobContainer blobContainer = this.blobContainerBuilder().maxRetries(maxRetries).build();
        boolean alwaysFlushBody = AbstractBlobContainerRetriesTestCase.randomBoolean();
        byte[] bytes = AbstractBlobContainerRetriesTestCase.randomBlobContent(1);
        this.httpServer.createContext(this.downloadStorageEndpoint(blobContainer, "read_blob_incomplete"), exchange -> {
            this.sendIncompleteContent(exchange, bytes);
            if (alwaysFlushBody) {
                exchange.getResponseBody().flush();
            }
            exchange.close();
        });
        Exception exception = (Exception)AbstractBlobContainerRetriesTestCase.expectThrows(Exception.class, () -> {
            try (InputStream stream = AbstractBlobContainerRetriesTestCase.randomBoolean() ? blobContainer.readBlob(this.randomFiniteRetryingPurpose(), "read_blob_incomplete", 0L, 1L) : blobContainer.readBlob(this.randomFiniteRetryingPurpose(), "read_blob_incomplete");){
                Streams.readFully((InputStream)stream);
            }
        });
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getMessage().toLowerCase(Locale.ROOT), Matchers.anyOf((Matcher)Matchers.containsString((String)"premature end of chunk coded message body: closing chunk expected"), (Matcher)Matchers.containsString((String)"premature end of content-length delimited message body"), (Matcher)Matchers.containsString((String)"connection closed prematurely"), (Matcher)Matchers.containsString((String)"premature eof"), (Matcher)(alwaysFlushBody ? NeverMatcher.never() : Matchers.containsString((String)"the target server failed to respond"))));
        AbstractBlobContainerRetriesTestCase.assertThat(exception.getSuppressed().length, this.getMaxRetriesMatcher(Math.min(10, maxRetries)));
    }

    protected static byte[] randomBlobContent() {
        return AbstractBlobContainerRetriesTestCase.randomBlobContent(1);
    }

    protected static byte[] randomBlobContent(int minSize) {
        return AbstractBlobContainerRetriesTestCase.randomByteArrayOfLength(AbstractBlobContainerRetriesTestCase.randomIntBetween(minSize, AbstractBlobContainerRetriesTestCase.frequently() ? 512 : 0x100000));
    }

    protected static HttpHeaderParser.Range getRange(HttpExchange exchange) {
        String rangeHeader = exchange.getRequestHeaders().getFirst("Range");
        if (rangeHeader == null) {
            return new HttpHeaderParser.Range(0L, 0x7FFFFFFFFFFFFFFEL);
        }
        HttpHeaderParser.Range range = HttpHeaderParser.parseRangeHeader(rangeHeader);
        AbstractBlobContainerRetriesTestCase.assertNotNull((String)(rangeHeader + " matches expected pattern"), (Object)range);
        AbstractBlobContainerRetriesTestCase.assertThat(range.start(), Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(range.end())));
        return range;
    }

    protected static int getRangeStart(HttpExchange exchange) {
        return Math.toIntExact(AbstractBlobContainerRetriesTestCase.getRange(exchange).start());
    }

    protected static OptionalInt getRangeEnd(HttpExchange exchange) {
        long rangeEnd = AbstractBlobContainerRetriesTestCase.getRange(exchange).end();
        if (rangeEnd == 0x7FFFFFFFFFFFFFFEL) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Math.toIntExact(rangeEnd));
    }

    protected int sendIncompleteContent(HttpExchange exchange, byte[] bytes) throws IOException {
        int length;
        int rangeStart = AbstractBlobContainerRetriesTestCase.getRangeStart(exchange);
        AbstractBlobContainerRetriesTestCase.assertThat(rangeStart, Matchers.lessThan((Comparable)Integer.valueOf(bytes.length)));
        OptionalInt rangeEnd = AbstractBlobContainerRetriesTestCase.getRangeEnd(exchange);
        if (rangeEnd.isPresent()) {
            int effectiveRangeEnd = Math.min(rangeEnd.getAsInt(), bytes.length - 1);
            length = effectiveRangeEnd - rangeStart + 1;
        } else {
            length = bytes.length - rangeStart;
        }
        exchange.getResponseHeaders().add("Content-Type", this.bytesContentType());
        exchange.sendResponseHeaders(200, length);
        int minSend = Math.min(0, length - 1);
        int bytesToSend = AbstractBlobContainerRetriesTestCase.randomIntBetween(minSend, length - 1);
        if (bytesToSend > 0) {
            exchange.getResponseBody().write(bytes, rangeStart, bytesToSend);
        }
        if (AbstractBlobContainerRetriesTestCase.randomBoolean() || Runtime.version().feature() >= 23) {
            exchange.getResponseBody().flush();
        }
        return bytesToSend;
    }

    protected abstract BlobContainer createBlobContainer(@Nullable Integer var1, @Nullable TimeValue var2, @Nullable Boolean var3, @Nullable Integer var4, @Nullable ByteSizeValue var5, @Nullable Integer var6, @Nullable BlobPath var7);

    protected final TestBlobContainerBuilder blobContainerBuilder() {
        return new TestBlobContainerBuilder();
    }

    protected final class TestBlobContainerBuilder {
        @Nullable
        private Integer maxRetries;
        @Nullable
        private TimeValue readTimeout;
        @Nullable
        private Boolean disableChunkedEncoding;
        @Nullable
        private Integer maxConnections;
        @Nullable
        private ByteSizeValue bufferSize;
        @Nullable
        private Integer maxBulkDeletes;
        @Nullable
        private BlobPath blobContainerPath;

        protected TestBlobContainerBuilder() {
        }

        public TestBlobContainerBuilder maxRetries(@Nullable Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public TestBlobContainerBuilder readTimeout(@Nullable TimeValue readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public TestBlobContainerBuilder disableChunkedEncoding(@Nullable Boolean disableChunkedEncoding) {
            this.disableChunkedEncoding = disableChunkedEncoding;
            return this;
        }

        public TestBlobContainerBuilder maxConnections(@Nullable Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public TestBlobContainerBuilder bufferSize(@Nullable ByteSizeValue bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public TestBlobContainerBuilder maxBulkDeletes(@Nullable Integer maxBulkDeletes) {
            this.maxBulkDeletes = maxBulkDeletes;
            return this;
        }

        public TestBlobContainerBuilder blobContainerPath(@Nullable BlobPath blobContainerPath) {
            this.blobContainerPath = blobContainerPath;
            return this;
        }

        public BlobContainer build() {
            return AbstractBlobContainerRetriesTestCase.this.createBlobContainer(this.maxRetries, this.readTimeout, this.disableChunkedEncoding, this.maxConnections, this.bufferSize, this.maxBulkDeletes, this.blobContainerPath);
        }
    }

    public static class ZeroInputStream
    extends InputStream {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final long length;
        private final AtomicLong reads;
        private volatile long mark;

        public ZeroInputStream(long length) {
            this.length = length;
            this.reads = new AtomicLong(0L);
            this.mark = -1L;
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            return this.reads.incrementAndGet() <= this.length ? 0 : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            if (len == 0) {
                return 0;
            }
            int available = this.available();
            if (available == 0) {
                return -1;
            }
            int toCopy = Math.min(len, available);
            Arrays.fill(b, off, off + toCopy, (byte)0);
            this.reads.addAndGet(toCopy);
            return toCopy;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.mark = this.reads.get();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.ensureOpen();
            this.reads.set(this.mark);
        }

        @Override
        public int available() throws IOException {
            this.ensureOpen();
            if (this.reads.get() >= this.length) {
                return 0;
            }
            try {
                return Math.toIntExact(this.length - this.reads.get());
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE;
            }
        }

        @Override
        public void close() {
            this.closed.set(true);
        }

        private void ensureOpen() throws IOException {
            if (this.closed.get()) {
                throw new IOException("Stream closed");
            }
        }
    }
}

