/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class TestProcessor
implements Processor {
    private final String type;
    private final String tag;
    private final String description;
    private final Function<IngestDocument, IngestDocument> ingestDocumentMapper;
    private final AtomicInteger invokedCounter = new AtomicInteger();

    public TestProcessor(Consumer<IngestDocument> ingestDocumentConsumer) {
        this(null, "test-processor", null, ingestDocumentConsumer);
    }

    public TestProcessor(RuntimeException e) {
        this(null, "test-processor", null, e);
    }

    public TestProcessor(String tag, String type, String description, RuntimeException e) {
        this(tag, type, description, (IngestDocument i) -> {
            throw e;
        });
    }

    public TestProcessor(String tag, String type, String description, Consumer<IngestDocument> ingestDocumentConsumer) {
        this(tag, type, description, (IngestDocument id) -> {
            ingestDocumentConsumer.accept((IngestDocument)id);
            return id;
        });
    }

    public TestProcessor(String tag, String type, String description, Function<IngestDocument, IngestDocument> ingestDocumentMapper) {
        this.ingestDocumentMapper = ingestDocumentMapper;
        this.type = type;
        this.tag = tag;
        this.description = description;
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        this.invokedCounter.incrementAndGet();
        try {
            this.ingestDocumentMapper.apply(ingestDocument);
        }
        catch (Exception e) {
            if (this.isAsync()) {
                handler.accept(null, e);
                return;
            }
            throw e;
        }
        handler.accept(ingestDocument, null);
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        this.invokedCounter.incrementAndGet();
        return this.ingestDocumentMapper.apply(ingestDocument);
    }

    public String getType() {
        return this.type;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDescription() {
        return this.description;
    }

    public int getInvokedCounter() {
        return this.invokedCounter.get();
    }

    public static final class Factory
    implements Processor.Factory {
        public TestProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            return new TestProcessor(processorTag, "test-processor", description, ingestDocument -> {});
        }
    }
}

