/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.FillMaskConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class FillMaskConfigUpdate
extends NlpConfigUpdate
implements NamedXContentObject {
    public static final String NAME = "fill_mask";
    private static final ObjectParser<Builder, Void> STRICT_PARSER = FillMaskConfigUpdate.createParser(false);
    private final Integer numTopClasses;
    private final String resultsField;

    public static FillMaskConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        Integer numTopClasses = (Integer)options.remove(NlpConfig.NUM_TOP_CLASSES.getPreferredName());
        String resultsField = (String)options.remove(NlpConfig.RESULTS_FIELD.getPreferredName());
        TokenizationUpdate tokenizationUpdate = NlpConfigUpdate.tokenizationFromMap(options);
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", options.keySet());
        }
        return new FillMaskConfigUpdate(numTopClasses, resultsField, tokenizationUpdate);
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME, lenient, Builder::new);
        parser.declareString(Builder::setResultsField, NlpConfig.RESULTS_FIELD);
        parser.declareInt(Builder::setNumTopClasses, NlpConfig.NUM_TOP_CLASSES);
        parser.declareNamedObject(Builder::setTokenizationUpdate, (p, c, n) -> (TokenizationUpdate)p.namedObject(TokenizationUpdate.class, n, (Object)lenient), NlpConfig.TOKENIZATION);
        return parser;
    }

    public static FillMaskConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public FillMaskConfigUpdate(Integer numTopClasses, String resultsField, TokenizationUpdate tokenizationUpdate) {
        super(tokenizationUpdate);
        this.numTopClasses = numTopClasses;
        this.resultsField = resultsField;
    }

    public FillMaskConfigUpdate(StreamInput in) throws IOException {
        super(in);
        this.numTopClasses = in.readOptionalInt();
        this.resultsField = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalInt(this.numTopClasses);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.numTopClasses != null) {
            builder.field(NlpConfig.NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        if (this.resultsField != null) {
            builder.field(NlpConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_0_0;
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof FillMaskConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    public Integer getNumTopClasses() {
        return this.numTopClasses;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setNumTopClasses(this.numTopClasses).setResultsField(this.resultsField).setTokenizationUpdate(this.tokenizationUpdate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillMaskConfigUpdate that = (FillMaskConfigUpdate)o;
        return Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.tokenizationUpdate, that.tokenizationUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.numTopClasses, this.resultsField, this.tokenizationUpdate);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, FillMaskConfigUpdate> {
        private Integer numTopClasses;
        private String resultsField;
        private TokenizationUpdate tokenizationUpdate;

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setTokenizationUpdate(TokenizationUpdate tokenizationUpdate) {
            this.tokenizationUpdate = tokenizationUpdate;
            return this;
        }

        @Override
        public FillMaskConfigUpdate build() {
            return new FillMaskConfigUpdate(this.numTopClasses, this.resultsField, this.tokenizationUpdate);
        }
    }
}

