/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.KnnScoreDocQuery;
import org.elasticsearch.search.vectors.QueryProfilerProvider;

public class ESKnnByteVectorQuery
extends KnnByteVectorQuery
implements QueryProfilerProvider {
    private final Integer kParam;
    private long vectorOpsCount;

    public ESKnnByteVectorQuery(String field, byte[] target, Integer k, int numCands, Query filter) {
        super(field, target, numCands, filter);
        this.kParam = k;
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query rewrittenQuery = super.rewrite(searcher);
        if (rewrittenQuery instanceof MatchNoDocsQuery) {
            return rewrittenQuery;
        }
        return KnnScoreDocQuery.fromQuery(rewrittenQuery, this.kParam == null ? this.k : this.kParam, searcher);
    }

    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = this.kParam == null ? super.mergeLeafResults(perLeafResults) : TopDocs.merge((int)this.kParam, (TopDocs[])perLeafResults);
        this.vectorOpsCount = topK.totalHits.value;
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.addVectorOpsCount(this.vectorOpsCount);
    }

    public Integer kParam() {
        return this.kParam;
    }
}

