/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class FilteredRestRequest
extends RestRequest {
    private final RestRequest restRequest;
    private final String[] excludeFields;
    private BytesReference filteredBytes;

    public FilteredRestRequest(RestRequest restRequest, Set<String> excludeFields) {
        super(restRequest);
        this.restRequest = restRequest;
        this.excludeFields = (String[])excludeFields.toArray(String[]::new);
        this.filteredBytes = null;
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public ReleasableBytesReference content() {
        if (this.filteredBytes == null) {
            Tuple<XContentType, Map<String, Object>> result = XContentHelper.convertToMap(this.restRequest.requiredContent(), true, this.restRequest.getXContentType());
            Map<String, Object> transformedSource = this.transformBody((Map)result.v2());
            try {
                XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)((XContentType)result.v1()).xContent()).map(transformedSource);
                this.filteredBytes = BytesReference.bytes(xContentBuilder);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to parse request", (Throwable)e, new Object[0]);
            }
        }
        return ReleasableBytesReference.wrap(this.filteredBytes);
    }

    protected Map<String, Object> transformBody(Map<String, Object> map) {
        return XContentMapValues.filter(map, null, this.excludeFields);
    }
}

