/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.AnalyzerComponents;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.ReloadableCustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final Settings analyzerSettings;
    private Analyzer customAnalyzer;

    public CustomAnalyzerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(name, settings);
        this.analyzerSettings = settings;
    }

    void build(IndexService.IndexCreationContext context, Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        this.customAnalyzer = CustomAnalyzerProvider.create(context, this.name(), this.analyzerSettings, tokenizers, charFilters, tokenFilters);
    }

    private static Analyzer create(IndexService.IndexCreationContext context, String name, Settings analyzerSettings, Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        int positionIncrementGap = 100;
        positionIncrementGap = analyzerSettings.getAsInt("position_increment_gap", positionIncrementGap);
        int offsetGap = analyzerSettings.getAsInt("offset_gap", -1);
        AnalyzerComponents components = AnalyzerComponents.createComponents(context, name, analyzerSettings, tokenizers, charFilters, tokenFilters);
        if (components.analysisMode().equals((Object)AnalysisMode.SEARCH_TIME)) {
            return new ReloadableCustomAnalyzer(components, positionIncrementGap, offsetGap);
        }
        return new CustomAnalyzer(components.getTokenizerFactory(), components.getCharFilters(), components.getTokenFilters(), positionIncrementGap, offsetGap);
    }

    @Override
    public Analyzer get() {
        return this.customAnalyzer;
    }
}

