/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExplainRequest
extends SingleShardRequest<ExplainRequest>
implements ToXContentObject {
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private String id;
    private String routing;
    private String preference;
    private QueryBuilder query;
    private String[] storedFields;
    private FetchSourceContext fetchSourceContext;
    private AliasFilter filteringAlias = AliasFilter.EMPTY;
    long nowInMillis;

    public ExplainRequest() {
    }

    public ExplainRequest(String index, String id) {
        this.index = index;
        this.id = id;
    }

    ExplainRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            String type = in.readString();
            assert ("_doc".equals(type));
        }
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.filteringAlias = AliasFilter.readFrom(in);
        this.storedFields = in.readOptionalStringArray();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::readFrom);
        this.nowInMillis = in.readVLong();
    }

    public String id() {
        return this.id;
    }

    public ExplainRequest id(String id) {
        this.id = id;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ExplainRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ExplainRequest parent(String parent) {
        this.routing = parent;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public ExplainRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public ExplainRequest query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    public ExplainRequest fetchSourceContext(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    public String[] storedFields() {
        return this.storedFields;
    }

    public ExplainRequest storedFields(String[] fields) {
        this.storedFields = fields;
        return this;
    }

    public AliasFilter filteringAlias() {
        return this.filteringAlias;
    }

    public ExplainRequest filteringAlias(AliasFilter filteringAlias) {
        if (filteringAlias != null) {
            this.filteringAlias = filteringAlias;
        }
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validateNonNullIndex();
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (this.query == null) {
            validationException = ValidateActions.addValidationError("query is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeNamedWriteable(this.query);
        this.filteringAlias.writeTo(out);
        out.writeOptionalStringArray(this.storedFields);
        out.writeOptionalWriteable(this.fetchSourceContext);
        out.writeVLong(this.nowInMillis);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(QUERY_FIELD.getPreferredName(), (ToXContent)this.query);
        builder.endObject();
        return builder;
    }
}

