/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.util.List;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractor;

public class ValueExtractorForAggregateMetricDouble
implements ValueExtractor {
    private final AggregateMetricDoubleBlock block;

    ValueExtractorForAggregateMetricDouble(TopNEncoder encoder, AggregateMetricDoubleBlock block) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE);
        this.block = block;
    }

    @Override
    public void writeValue(BreakingBytesRefBuilder values, int position) {
        TopNEncoder.DEFAULT_UNSORTABLE.encodeVInt(1, values);
        for (DoubleBlock doubleBlock : List.of(this.block.minBlock(), this.block.maxBlock(), this.block.sumBlock())) {
            if (doubleBlock.isNull(position)) {
                TopNEncoder.DEFAULT_UNSORTABLE.encodeBoolean(false, values);
                continue;
            }
            TopNEncoder.DEFAULT_UNSORTABLE.encodeBoolean(true, values);
            TopNEncoder.DEFAULT_UNSORTABLE.encodeDouble(doubleBlock.getDouble(position), values);
        }
        IntBlock intBlock = this.block.countBlock();
        if (intBlock.isNull(position)) {
            TopNEncoder.DEFAULT_UNSORTABLE.encodeBoolean(false, values);
        } else {
            TopNEncoder.DEFAULT_UNSORTABLE.encodeBoolean(true, values);
            TopNEncoder.DEFAULT_UNSORTABLE.encodeInt(intBlock.getInt(position), values);
        }
    }

    public String toString() {
        return "ValueExtractorForAggregateMetricDouble";
    }
}

