/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data.sort;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.sort.BucketedSortCommon;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortOrder;

public class BytesRefBucketedSort
implements Releasable {
    private final BucketedSortCommon common;
    private final CircuitBreaker breaker;
    private final String label;
    private ObjectArray<BreakingBytesRefBuilder> values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRefBucketedSort(CircuitBreaker breaker, String label, BigArrays bigArrays, SortOrder order, int bucketSize) {
        this.breaker = breaker;
        this.label = label;
        this.common = new BucketedSortCommon(bigArrays, order, bucketSize);
        boolean success = false;
        try {
            this.values = bigArrays.newObjectArray(0L);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    private void checkInvariant(int bucket) {
        if (!Assertions.ENABLED) {
            return;
        }
        long rootIndex = this.common.rootIndex(bucket);
        long requiredSize = this.common.endIndex(rootIndex);
        if (this.values.size() < requiredSize) {
            throw new AssertionError((Object)("values too short " + this.values.size() + " < " + requiredSize));
        }
        if (this.values.get(rootIndex) == null) {
            throw new AssertionError((Object)"new gather offset can't be null");
        }
        if (!this.common.inHeapMode(bucket)) {
            this.common.assertValidNextOffset(this.getNextGatherOffset(rootIndex));
        } else {
            for (long l = rootIndex; l < this.common.endIndex(rootIndex); ++l) {
                if (this.values.get(rootIndex) == null) {
                    throw new AssertionError((Object)"values missing in heap mode");
                }
            }
        }
    }

    public void collect(BytesRef value, int bucket) {
        long rootIndex = this.common.rootIndex(bucket);
        if (this.common.inHeapMode(bucket)) {
            if (this.betterThan(value, ((BreakingBytesRefBuilder)this.values.get(rootIndex)).bytesRefView())) {
                this.clearedBytesAt(rootIndex).append(value);
                this.downHeap(rootIndex, 0);
            }
            this.checkInvariant(bucket);
            return;
        }
        long requiredSize = this.common.endIndex(rootIndex);
        if (this.values.size() < requiredSize) {
            this.grow(bucket);
        }
        int next = this.getNextGatherOffset(rootIndex);
        this.common.assertValidNextOffset(next);
        long index = (long)next + rootIndex;
        this.clearedBytesAt(index).append(value);
        if (next == 0) {
            this.common.enableHeapMode(bucket);
            this.heapify(rootIndex);
        } else {
            ByteUtils.writeIntLE((int)(next - 1), (byte[])((BreakingBytesRefBuilder)this.values.get(rootIndex)).bytes(), (int)0);
        }
        this.checkInvariant(bucket);
    }

    public void merge(int bucket, BytesRefBucketedSort other, int otherBucket) {
        long otherRootIndex = other.common.rootIndex(otherBucket);
        if (otherRootIndex >= other.values.size()) {
            return;
        }
        other.checkInvariant(otherBucket);
        long otherStart = other.startIndex(otherBucket, otherRootIndex);
        long otherEnd = other.common.endIndex(otherRootIndex);
        for (long i = otherStart; i < otherEnd; ++i) {
            this.collect(((BreakingBytesRefBuilder)other.values.get(i)).bytesRefView(), bucket);
        }
    }

    public Block toBlock(BlockFactory blockFactory, IntVector selected) {
        if (IntStream.range(0, selected.getPositionCount()).map(selected::getInt).noneMatch(bucket -> {
            long rootIndex = this.common.rootIndex(bucket);
            if (rootIndex >= this.values.size()) {
                return false;
            }
            long start = this.startIndex(bucket, rootIndex);
            long end = this.common.endIndex(rootIndex);
            long size = end - start;
            return size > 0L;
        })) {
            return blockFactory.newConstantNullBlock(selected.getPositionCount());
        }
        Object[] bucketValues = new BytesRef[this.common.bucketSize];
        try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int s = 0; s < selected.getPositionCount(); ++s) {
                int bucket2 = selected.getInt(s);
                long rootIndex = this.common.rootIndex(bucket2);
                if (rootIndex >= this.values.size()) {
                    builder.appendNull();
                    continue;
                }
                long start = this.startIndex(bucket2, rootIndex);
                long end = this.common.endIndex(rootIndex);
                long size = end - start;
                if (size == 0L) {
                    builder.appendNull();
                    continue;
                }
                if (size == 1L) {
                    try (BreakingBytesRefBuilder bytes = (BreakingBytesRefBuilder)this.values.get(start);){
                        builder.appendBytesRef(bytes.bytesRefView());
                    }
                    this.values.set(start, null);
                    continue;
                }
                int i = 0;
                while ((long)i < size) {
                    try (BreakingBytesRefBuilder bytes = (BreakingBytesRefBuilder)this.values.get(start + (long)i);){
                        bucketValues[i] = bytes.bytesRefView();
                    }
                    this.values.set(start + (long)i, null);
                    ++i;
                }
                Arrays.sort(bucketValues, 0, (int)size);
                builder.beginPositionEntry();
                if (this.common.order == SortOrder.ASC) {
                    i = 0;
                    while ((long)i < size) {
                        builder.appendBytesRef((BytesRef)bucketValues[i]);
                        ++i;
                    }
                } else {
                    for (i = (int)size - 1; i >= 0; --i) {
                        builder.appendBytesRef((BytesRef)bucketValues[i]);
                    }
                }
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private long startIndex(int bucket, long rootIndex) {
        if (this.common.inHeapMode(bucket)) {
            return rootIndex;
        }
        return rootIndex + (long)this.getNextGatherOffset(rootIndex) + 1L;
    }

    private int getNextGatherOffset(long rootIndex) {
        BreakingBytesRefBuilder bytes = (BreakingBytesRefBuilder)this.values.get(rootIndex);
        assert (bytes.length() == 4);
        return ByteUtils.readIntLE((byte[])bytes.bytes(), (int)0);
    }

    private boolean betterThan(BytesRef lhs, BytesRef rhs) {
        return this.common.order.reverseMul() * lhs.compareTo(rhs) < 0;
    }

    private void swap(long lhs, long rhs) {
        BreakingBytesRefBuilder tmp = (BreakingBytesRefBuilder)this.values.get(lhs);
        this.values.set(lhs, (Object)((BreakingBytesRefBuilder)this.values.get(rhs)));
        this.values.set(rhs, (Object)tmp);
    }

    private void grow(int bucket) {
        long oldMax = this.values.size();
        assert (oldMax % (long)this.common.bucketSize == 0L);
        long newSize = BigArrays.overSize((long)(((long)bucket + 1L) * (long)this.common.bucketSize), (int)PageCacheRecycler.OBJECT_PAGE_SIZE, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        newSize = (newSize + (long)this.common.bucketSize - 1L) / (long)this.common.bucketSize;
        this.values = this.common.bigArrays.resize(this.values, newSize * (long)this.common.bucketSize);
        this.fillGatherOffsets(oldMax);
    }

    private void fillGatherOffsets(long startingAt) {
        assert (startingAt % (long)this.common.bucketSize == 0L);
        int nextOffset = this.common.bucketSize - 1;
        for (long bucketRoot = startingAt; bucketRoot < this.values.size(); bucketRoot += (long)this.common.bucketSize) {
            BreakingBytesRefBuilder bytes = (BreakingBytesRefBuilder)this.values.get(bucketRoot);
            if (bytes != null) continue;
            bytes = new BreakingBytesRefBuilder(this.breaker, this.label);
            this.values.set(bucketRoot, (Object)bytes);
            bytes.grow(4);
            bytes.setLength(4);
            ByteUtils.writeIntLE((int)nextOffset, (byte[])bytes.bytes(), (int)0);
            this.checkInvariant(Math.toIntExact(bucketRoot / (long)this.common.bucketSize));
        }
    }

    private void heapify(long rootIndex) {
        int maxParent;
        for (int parent = maxParent = this.common.bucketSize / 2 - 1; parent >= 0; --parent) {
            this.downHeap(rootIndex, parent);
        }
    }

    private void downHeap(long rootIndex, int parent) {
        while (true) {
            long parentIndex = rootIndex + (long)parent;
            int worst = parent;
            long worstIndex = parentIndex;
            int leftChild = parent * 2 + 1;
            long leftIndex = rootIndex + (long)leftChild;
            if (leftChild < this.common.bucketSize) {
                if (this.betterThan(((BreakingBytesRefBuilder)this.values.get(worstIndex)).bytesRefView(), ((BreakingBytesRefBuilder)this.values.get(leftIndex)).bytesRefView())) {
                    worst = leftChild;
                    worstIndex = leftIndex;
                }
                int rightChild = leftChild + 1;
                long rightIndex = rootIndex + (long)rightChild;
                if (rightChild < this.common.bucketSize && this.betterThan(((BreakingBytesRefBuilder)this.values.get(worstIndex)).bytesRefView(), ((BreakingBytesRefBuilder)this.values.get(rightIndex)).bytesRefView())) {
                    worst = rightChild;
                    worstIndex = rightIndex;
                }
            }
            if (worst == parent) break;
            this.swap(worstIndex, parentIndex);
            parent = worst;
        }
    }

    private BreakingBytesRefBuilder clearedBytesAt(long index) {
        BreakingBytesRefBuilder bytes = (BreakingBytesRefBuilder)this.values.get(index);
        if (bytes == null) {
            bytes = new BreakingBytesRefBuilder(this.breaker, this.label);
            this.values.set(index, (Object)bytes);
        } else {
            bytes.clear();
        }
        return bytes;
    }

    public final void close() {
        Releasable allValues = this.values == null ? () -> {} : Releasables.wrap(LongStream.range(0L, this.values.size()).mapToObj(i -> {
            BreakingBytesRefBuilder bytes = (BreakingBytesRefBuilder)this.values.get(i);
            return bytes == null ? () -> {} : bytes;
        }).toList().iterator());
        Releasables.close((Releasable[])new Releasable[]{allValues, this.values, this.common});
    }
}

