/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.inference;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;

public class Rerank
extends InferencePlan<Rerank>
implements TelemetryAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Rerank", Rerank::new);
    public static final String DEFAULT_INFERENCE_ID = ".rerank-v1-elasticsearch";
    public static final String INFERENCE_ID_OPTION_NAME = "inferenceId";
    public static final String SCORE_COLUMN_OPTION_NAME = "scoreColumn";
    private final Attribute scoreAttribute;
    private final Expression queryText;
    private final List<Alias> rerankFields;
    private List<Attribute> lazyOutput;

    public Rerank(Source source, LogicalPlan child, Expression queryText, List<Alias> rerankFields) {
        this(source, child, (Expression)Literal.keyword((Source)Source.EMPTY, (String)DEFAULT_INFERENCE_ID), queryText, rerankFields, (Attribute)new UnresolvedAttribute(Source.EMPTY, "_score"));
    }

    public Rerank(Source source, LogicalPlan child, Expression inferenceId, Expression queryText, List<Alias> rerankFields, Attribute scoreAttribute) {
        super(source, child, inferenceId);
        this.queryText = queryText;
        this.rerankFields = rerankFields;
        this.scoreAttribute = scoreAttribute;
    }

    public Rerank(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), in.readCollectionAsList(Alias::new), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.queryText);
        out.writeCollection(this.rerankFields());
        out.writeNamedWriteable((NamedWriteable)this.scoreAttribute);
    }

    public Expression queryText() {
        return this.queryText;
    }

    public List<Alias> rerankFields() {
        return this.rerankFields;
    }

    public Attribute scoreAttribute() {
        return this.scoreAttribute;
    }

    @Override
    public TaskType taskType() {
        return TaskType.RERANK;
    }

    @Override
    public Rerank withInferenceId(Expression newInferenceId) {
        return new Rerank(this.source(), this.child(), newInferenceId, this.queryText, this.rerankFields, this.scoreAttribute);
    }

    public Rerank withRerankFields(List<Alias> newRerankFields) {
        return new Rerank(this.source(), this.child(), this.inferenceId(), this.queryText, newRerankFields, this.scoreAttribute);
    }

    public Rerank withScoreAttribute(Attribute newScoreAttribute) {
        return new Rerank(this.source(), this.child(), this.inferenceId(), this.queryText, this.rerankFields, newScoreAttribute);
    }

    public String getWriteableName() {
        return Rerank.ENTRY.name;
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Rerank(this.source(), newChild, this.inferenceId(), this.queryText, this.rerankFields, this.scoreAttribute);
    }

    @Override
    protected AttributeSet computeReferences() {
        return Rerank.computeReferences(this.rerankFields);
    }

    @Override
    public List<Attribute> generatedAttributes() {
        return List.of(this.scoreAttribute);
    }

    @Override
    public Rerank withGeneratedNames(List<String> newNames) {
        this.checkNumberOfNewNames(newNames);
        return new Rerank(this.source(), this.child(), this.inferenceId(), this.queryText, this.rerankFields, this.renameScoreAttribute(newNames.get(0)));
    }

    private Attribute renameScoreAttribute(String newName) {
        if (newName.equals(this.scoreAttribute.name())) {
            return this.scoreAttribute;
        }
        return this.scoreAttribute.withName(newName).withId(new NameId());
    }

    public static AttributeSet computeReferences(List<Alias> fields) {
        AttributeSet rerankFields = AttributeSet.of((Collection)Expressions.asAttributes(fields));
        return Expressions.references(fields).subtract(rerankFields);
    }

    @Override
    public boolean expressionsResolved() {
        return super.expressionsResolved() && this.queryText.resolved() && Resolvables.resolved(this.rerankFields) && this.scoreAttribute.resolved();
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Rerank::new, (Object)((Object)this.child()), (Object)this.inferenceId(), (Object)this.queryText, this.rerankFields, (Object)this.scoreAttribute);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Rerank rerank = (Rerank)o;
        return Objects.equals(this.queryText, rerank.queryText) && Objects.equals(this.rerankFields, rerank.rerankFields) && Objects.equals(this.scoreAttribute, rerank.scoreAttribute);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.queryText, this.rerankFields, this.scoreAttribute);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(List.of(this.scoreAttribute), this.child().output());
        }
        return this.lazyOutput;
    }

    public static class Builder {
        private Rerank rerank;

        public Builder(Rerank rerank) {
            this.rerank = rerank;
        }

        public Rerank build() {
            return this.rerank;
        }

        public Builder withInferenceId(Expression inferenceId) {
            this.rerank = this.rerank.withInferenceId(inferenceId);
            return this;
        }

        public Builder withScoreAttribute(Attribute scoreAttribute) {
            this.rerank = this.rerank.withScoreAttribute(scoreAttribute);
            return this;
        }
    }
}

