/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.ruby.ConfigVisitor;

class RubyPrintWriter
extends PrintWriter {
    private static final String INDENT = "  ";
    private String current = "";

    RubyPrintWriter(Writer writer) {
        super(writer);
    }

    void inc() {
        this.current = String.valueOf(this.current) + INDENT;
    }

    void dec() {
        this.current = this.current.substring(INDENT.length());
    }

    @Override
    public void print(String value) {
        this.append(this.current).append(value);
    }

    void print(String name, String ... values) {
        if (values.length == 1 && values[0] == null) {
            return;
        }
        this.append(this.current).append(name).append(" ");
        boolean first = true;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value != null) {
                if (first) {
                    first = false;
                } else {
                    this.append(", ");
                }
                if (value.startsWith(":")) {
                    this.append(value);
                } else {
                    this.append("'").append(this.escape(value)).append("'");
                }
            }
            ++n2;
        }
    }

    private String escape(String value) {
        return value.replaceAll("([^\\\\])'", "$1\\\\'");
    }

    @Override
    public void println(String name) {
        this.print(name);
        this.println();
    }

    void println(String name, String ... values) {
        if (values.length == 1 && values[0] == null) {
            return;
        }
        this.print(name, values);
        this.println();
    }

    void printWithOptions(String prefix, Map<String, Object> options, String ... args) {
        this.printWithOptions(prefix, options, (Object)null, args);
    }

    void printWithOptions(String prefix, Map<String, Object> options, boolean newLine, String ... args) {
        this.printWithOptions(prefix, options, null, newLine, args);
    }

    void printWithOptions(String prefix, Map<String, Object> options, Object config, String ... args) {
        this.printWithOptions(prefix, options, config, true, args);
    }

    void printWithOptions(String prefix, Map<String, Object> options, Object config, boolean newLine, String ... args) {
        if (!options.isEmpty() || config != null) {
            prefix = String.valueOf(prefix) + "(";
            this.print(prefix, args);
            String indent = String.valueOf(prefix.replaceAll(".", " ")) + ' ';
            boolean first = args.length == 0;
            for (Map.Entry<String, Object> item : options.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    this.append(",").println();
                    this.print(indent);
                }
                this.appendName(item.getKey()).append(" => ");
                if (item.getValue() instanceof String) {
                    this.append("'").append(this.escape(item.getValue().toString())).append("'");
                    continue;
                }
                this.append(item.getValue().toString());
            }
            if (config != null) {
                this.printConfiguration(indent, config);
                if (newLine) {
                    this.println();
                }
            } else {
                this.append(" )");
                if (newLine) {
                    this.println();
                }
            }
        } else {
            this.println(prefix, args);
        }
    }

    void printConfiguration(String indent, Object config) {
        if (config != null) {
            Xpp3Dom configuration = (Xpp3Dom)config;
            if (configuration.getChildCount() != 0) {
                this.append(",");
                this.println();
                ConfigVisitor visitor = new ConfigVisitor();
                visitor.visit(new ConfigVisitor.Node(configuration));
                this.printHashConfig(indent, visitor.config.map);
            }
            this.append(" )");
        }
    }

    void printHashConfig(String indent, Map<String, ConfigVisitor.Config> base) {
        this.printHashConfig(indent, base, false);
    }

    RubyPrintWriter appendName(String name) {
        if (name.matches("^[a-zA-Z_]*$")) {
            this.append(":").append(name);
        } else {
            this.append("'").append(this.escape(name)).append("'");
        }
        return this;
    }

    void printHashConfig(String indent, Map<String, ConfigVisitor.Config> base, boolean skipFirst) {
        boolean first = true;
        for (Map.Entry<String, ConfigVisitor.Config> entry : base.entrySet()) {
            if (first) {
                first = false;
                if (!skipFirst) {
                    this.print(indent);
                }
            } else {
                this.append(",").println();
                this.print(indent);
            }
            ConfigVisitor.Config config = entry.getValue();
            switch (config.type) {
                case SINGLE: {
                    this.append("'").append(entry.getKey()).append("' => ");
                    if (config.value != null) {
                        this.append(" '").append(this.escape(config.value)).append("'");
                        break;
                    }
                    this.append("nil");
                    break;
                }
                case MULTI: {
                    Object c;
                    this.append("'").append(entry.getKey()).append("' => [");
                    String ind = String.valueOf(indent) + "       " + entry.getKey().replaceAll(".", " ");
                    int count = config.stringList.size();
                    int j = 0;
                    while (j < count) {
                        c = config.stringList.get(j);
                        if (c != null) {
                            this.append(" '").append(this.escape((String)c)).append("'");
                        } else {
                            this.append("nil");
                        }
                        if (++j >= count) continue;
                        this.append(",");
                        this.println();
                        this.print(ind);
                    }
                    this.append(" ]");
                    break;
                }
                case MIXED: {
                    Object c;
                    this.append("'").append(entry.getKey()).append("' => [");
                    String ind = String.valueOf(indent) + "       " + entry.getKey().replaceAll(".", " ");
                    int count = config.list.size();
                    int j = 0;
                    while (j < count) {
                        c = config.list.get(j);
                        if (((ConfigVisitor.ListItem)c).isXml()) {
                            this.append(" xml( '").append(this.escape(((ConfigVisitor.ListItem)c).xml)).append("' )");
                        } else {
                            this.append(" '").append(this.escape(((ConfigVisitor.ListItem)c).value)).append("'");
                        }
                        if (++j >= count) continue;
                        this.append(",");
                        this.println();
                        this.print(ind);
                    }
                    this.append(" ]");
                    break;
                }
                case MAPS: {
                    Object c;
                    this.append("'").append(entry.getKey()).append("' => [");
                    String ind = String.valueOf(indent) + "       " + entry.getKey().replaceAll(".", " ");
                    int count = config.mapList.size();
                    int j = 0;
                    while (j < count) {
                        c = config.mapList.get(j);
                        this.append(" { ");
                        this.printHashConfig(" " + ind + INDENT, (Map<String, ConfigVisitor.Config>)c, true);
                        this.append(" }");
                        if (++j >= count) continue;
                        this.append(",");
                        this.println();
                        this.print(ind);
                    }
                    this.append(" ]");
                    break;
                }
                case MAP: {
                    this.append("'").append(entry.getKey()).append("' => {").println();
                    this.printHashConfig(String.valueOf(indent) + INDENT, entry.getValue().map, false);
                    this.println();
                    this.print(indent);
                    this.append("}");
                }
            }
        }
    }

    void printStartBlock(String name) {
        this.print(name);
        this.printStartBlock();
    }

    void printStartBlock(String name, String ... values) {
        this.printStartBlock(name, (Map<String, Object>)null, values);
    }

    void printStartBlock(String name, Map<String, Object> options, String ... values) {
        if (options != null) {
            this.printWithOptions(name, options, false, values);
        } else {
            this.print(name, values);
        }
        this.printStartBlock();
    }

    void printStartBlock() {
        this.append(" do");
        this.println();
        this.inc();
    }

    void printEndBlock() {
        this.dec();
        this.append(this.current).append("end");
        this.println();
    }
}

