/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class RSAUtil {
    RSAUtil() {
    }

    static String getDigestSigAlgName(String string) {
        int n = string.indexOf(45);
        if (n > 0 && !string.startsWith("SHA3")) {
            return string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    static AlgorithmParameterSpec getPSSParameterSpec(int n, String string, JcaJceHelper jcaJceHelper) {
        int n2 = TlsCryptoUtils.getHashOutputSize(n);
        MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(string);
        return new PSSParameterSpec(string, "MGF1", mGF1ParameterSpec, n2, 1);
    }
}

