/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.eclipse.sisu.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.PolyglotModelManager;
import org.sonatype.maven.polyglot.PolyglotPropertiesEnhancer;

@Singleton
@Named
@Priority(value=10)
public class TeslaModelProcessor
implements ModelProcessor {
    private static final String DEFAULT_POM_FILE = "pom.xml";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String WARNING = "?>" + NEW_LINE + "<!--" + NEW_LINE + NEW_LINE + NEW_LINE + "DO NOT MODIFY - GENERATED CODE" + NEW_LINE + NEW_LINE + NEW_LINE + "-->";
    private static final String POM_FILE_PREFIX = ".polyglot.";
    @Inject
    private PolyglotModelManager manager;
    private Logger log = LoggerFactory.getLogger(TeslaModelProcessor.class);

    public File locatePom(File dir) {
        assert (this.manager != null);
        File pomFile = this.manager.findPom(dir);
        if (pomFile == null) {
            return new File(dir, DEFAULT_POM_FILE);
        }
        if (pomFile.getName().equals(DEFAULT_POM_FILE) && pomFile.getParentFile().equals(dir)) {
            return pomFile;
        }
        File polyglotPomFile = new File(pomFile.getParentFile(), POM_FILE_PREFIX + pomFile.getName());
        try {
            if (!polyglotPomFile.exists() && polyglotPomFile.createNewFile()) {
                polyglotPomFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error creating empty file", e);
        }
        return polyglotPomFile;
    }

    public Model read(File input, Map<String, ?> options) throws IOException, ModelParseException {
        Model model;
        Throwable throwable = null;
        Object var5_5 = null;
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)input);){
            model = this.read((Reader)reader, options);
            model.setPomFile(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return model;
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException, ModelParseException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)input);){
            return this.read((Reader)reader, options);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException, ModelParseException {
        assert (this.manager != null);
        Optional<File> optionalPomXml = this.getPomXmlFile(options);
        if (optionalPomXml.isPresent()) {
            File dumpPom;
            File pom = optionalPomXml.get();
            this.log.debug(pom.toString());
            File realPom = new File(pom.getPath().replaceFirst(Pattern.quote(POM_FILE_PREFIX), ""));
            options.put("org.apache.maven.model.building.source", new FileModelSource(realPom));
            ModelReader reader = this.manager.getReaderFor(options);
            Model model = reader.read(realPom, options);
            PolyglotPropertiesEnhancer.enhanceModel(this.manager.getEnhancementPropertiesFor(options), model);
            MavenXpp3Writer xmlWriter = new MavenXpp3Writer();
            StringWriter xml = new StringWriter();
            xmlWriter.write((Writer)xml, model);
            FileUtils.fileWrite((File)pom, (String)xml.toString());
            String dump = model.getProperties().getProperty("polyglot.dump.pom");
            if (dump == null) {
                dump = System.getProperty("polyglot.dump.pom");
            }
            if (!(dump == null || (dumpPom = new File(pom.getParentFile(), dump)).exists() && FileUtils.fileRead((File)dumpPom).equals(xml.toString().replace("?>", WARNING)))) {
                dumpPom.setWritable(true);
                FileUtils.fileWrite((File)dumpPom, (String)xml.toString().replace("?>", WARNING));
                if ("true".equals(model.getProperties().getProperty("polyglot.dump.readonly"))) {
                    dumpPom.setReadOnly();
                }
            }
            model.setPomFile(pom);
            return model;
        }
        ModelReader reader = this.manager.getReaderFor(options);
        return reader.read(input, options);
    }

    private Optional<File> getPomXmlFile(Map<String, ?> options) {
        ModelSource source = (ModelSource)options.get("org.apache.maven.model.building.source");
        if (source != null) {
            return this.getPomXmlFile(new File(source.getLocation()));
        }
        return Optional.empty();
    }

    Optional<File> getPomXmlFile(File sourceFile) {
        String filename = sourceFile.getName();
        if (filename.startsWith(POM_FILE_PREFIX)) {
            return Optional.of(sourceFile);
        }
        if (!filename.equals(DEFAULT_POM_FILE) && !filename.endsWith(".pom")) {
            File parent = sourceFile.getParentFile();
            if (parent == null) {
                return Optional.empty();
            }
            File pom = this.locatePom(parent);
            if (pom.getName().startsWith(POM_FILE_PREFIX)) {
                return Optional.of(pom);
            }
        }
        return Optional.empty();
    }
}

